/*
 * Decompiled with CFR 0.152.
 */
package com.github.adituv.runedokuplugin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.runelite.client.ui.overlay.RenderableEntity;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;

public class OutlineTextComponent
implements RenderableEntity {
    private static final String COL_TAG_REGEX = "(<col=([0-9a-fA-F]){2,6}>)";
    private static final Pattern COL_TAG_PATTERN_W_LOOKAHEAD = Pattern.compile("(?=(<col=([0-9a-fA-F]){2,6}>))");
    private String text;
    private Point position = new Point();
    private Color color = Color.WHITE;
    private boolean shadow = true;
    @Nullable
    private Font font;
    private int outlineWidth = 1;
    private Color outlineColor = Color.BLACK;

    public Dimension render(Graphics2D graphics) {
        Font originalFont = graphics.getFont();
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (COL_TAG_PATTERN_W_LOOKAHEAD.matcher(this.text).find()) {
            String[] parts = COL_TAG_PATTERN_W_LOOKAHEAD.split(this.text);
            int x = this.position.x;
            for (String textSplitOnCol : parts) {
                String textWithoutCol = Text.removeTags((String)textSplitOnCol);
                String colColor = textSplitOnCol.substring(textSplitOnCol.indexOf("=") + 1, textSplitOnCol.indexOf(">"));
                if (this.outlineWidth > 0) {
                    graphics.setColor(ColorUtil.colorWithAlpha((Color)this.outlineColor, (int)255));
                    graphics.drawString(textWithoutCol, x + this.outlineWidth, this.position.y + this.outlineWidth);
                    graphics.drawString(textWithoutCol, x, this.position.y + this.outlineWidth);
                    graphics.drawString(textWithoutCol, x - this.outlineWidth, this.position.y + this.outlineWidth);
                    graphics.drawString(textWithoutCol, x + this.outlineWidth, this.position.y);
                    graphics.drawString(textWithoutCol, x - this.outlineWidth, this.position.y);
                    graphics.drawString(textWithoutCol, x + this.outlineWidth, this.position.y - this.outlineWidth);
                    graphics.drawString(textWithoutCol, x, this.position.y - this.outlineWidth);
                    graphics.drawString(textWithoutCol, x - this.outlineWidth, this.position.y - this.outlineWidth);
                } else if (this.shadow) {
                    graphics.setColor(Color.BLACK);
                    graphics.drawString(textWithoutCol, x + 1, this.position.y + 1);
                }
                graphics.setColor(Color.decode("#" + colColor));
                graphics.drawString(textWithoutCol, x, this.position.y);
                x += fontMetrics.stringWidth(textWithoutCol);
            }
        } else {
            graphics.setColor(Color.BLACK);
            if (this.outlineWidth > 0) {
                graphics.setColor(ColorUtil.colorWithAlpha((Color)this.outlineColor, (int)255));
                graphics.drawString(this.text, this.position.x + this.outlineWidth, this.position.y + this.outlineWidth);
                graphics.drawString(this.text, this.position.x, this.position.y + this.outlineWidth);
                graphics.drawString(this.text, this.position.x - this.outlineWidth, this.position.y + this.outlineWidth);
                graphics.drawString(this.text, this.position.x + this.outlineWidth, this.position.y);
                graphics.drawString(this.text, this.position.x - this.outlineWidth, this.position.y);
                graphics.drawString(this.text, this.position.x + this.outlineWidth, this.position.y - this.outlineWidth);
                graphics.drawString(this.text, this.position.x, this.position.y - this.outlineWidth);
                graphics.drawString(this.text, this.position.x - this.outlineWidth, this.position.y - this.outlineWidth);
            } else if (this.shadow) {
                graphics.setColor(Color.BLACK);
                graphics.drawString(this.text, this.position.x + 1, this.position.y + 1);
            }
            graphics.setColor(ColorUtil.colorWithAlpha((Color)this.color, (int)255));
            graphics.drawString(this.text, this.position.x, this.position.y);
        }
        int width = fontMetrics.stringWidth(this.text);
        int height = fontMetrics.getHeight();
        if (originalFont != null) {
            graphics.setFont(originalFont);
        }
        return new Dimension(width, height);
    }

    public void setOutline(int width, Color color) {
        this.setOutlineWidth(width);
        this.setOutlineColor(color);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setFont(@Nullable Font font) {
        this.font = font;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }
}

