/*
 * Decompiled with CFR 0.152.
 */
package com.FeroxRestoreAlert;

import com.FeroxRestoreAlert.FeroxRestoreAlertConfig;
import com.FeroxRestoreAlert.FeroxRestoreAlertOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ferox Restore Alert")
public class FeroxRestoreAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FeroxRestoreAlertPlugin.class);
    @Inject
    private Client client;
    @Inject
    private FeroxRestoreAlertConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FeroxRestoreAlertOverlay feroxRestoreAlertOverlay;
    private int maxPrayerValue = 0;
    private int currentPrayerValue = 0;
    private int maxHitpointsValue = 0;
    private int currentHitpointsValue = 0;
    private int customEnergyRestoreValue = 0;
    private int currentEnergyPercentage = 0;
    private final WorldArea feroxArea = new WorldArea(3123, 3617, 31, 21, 0);
    int tickCounter = 0;

    protected void startUp() {
        log.info("Ferox Restore Alert started!");
        this.overlayManager.add((Overlay)this.feroxRestoreAlertOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.feroxRestoreAlertOverlay);
        log.info("Ferox Restore Alert stopped!");
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateMaxStatValues();
        this.updateCurrentStatValues();
        this.customEnergyRestoreValue = this.config.getCustomEnergyRestoreValue();
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (this.feroxArea.contains(playerLocation) && !this.checkStatsAreRestored() && this.tickCounter % 2 == 0) {
            this.feroxRestoreAlertOverlay.showOverlay();
            ++this.tickCounter;
        } else {
            this.feroxRestoreAlertOverlay.hideOverlay();
            this.tickCounter = 0;
        }
        if (!this.feroxArea.contains(playerLocation) || this.checkStatsAreRestored()) {
            this.feroxRestoreAlertOverlay.hideOverlay();
        }
    }

    public void updateMaxPrayerValue() {
        this.maxPrayerValue = this.client.getRealSkillLevel(Skill.PRAYER);
    }

    public void updateCurrentPrayerValue() {
        this.currentPrayerValue = this.client.getBoostedSkillLevel(Skill.PRAYER);
    }

    public void updateMaxHitpointsValue() {
        this.maxHitpointsValue = this.client.getRealSkillLevel(Skill.HITPOINTS);
    }

    public void updateCurrentHitpointsValue() {
        this.currentHitpointsValue = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
    }

    public void updateCurrentEnergyPercentage() {
        this.currentEnergyPercentage = Math.floorDiv(this.client.getEnergy(), 100);
    }

    public void updateMaxStatValues() {
        this.updateMaxPrayerValue();
        this.updateMaxHitpointsValue();
    }

    public void updateCurrentStatValues() {
        this.updateCurrentPrayerValue();
        this.updateCurrentHitpointsValue();
        this.updateCurrentEnergyPercentage();
    }

    public boolean checkStatsAreRestored() {
        return this.currentPrayerValue == this.maxPrayerValue && this.currentHitpointsValue == this.maxHitpointsValue && this.currentEnergyPercentage >= this.customEnergyRestoreValue;
    }

    @Provides
    FeroxRestoreAlertConfig provideConfig(ConfigManager configManager) {
        return (FeroxRestoreAlertConfig)configManager.getConfig(FeroxRestoreAlertConfig.class);
    }
}

