/*
 * Decompiled with CFR 0.152.
 */
package com.FeroxRestoreAlert;

import com.FeroxRestoreAlert.FeroxRestoreAlertConfig;
import com.FeroxRestoreAlert.FeroxRestoreAlertPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class FeroxRestoreAlertOverlay
extends Overlay {
    @Inject
    private FeroxRestoreAlertConfig config;
    private final Client client;
    private final PanelComponent panelComponent = new PanelComponent();
    private final OverlayManager overlayManager;
    private boolean isVisible = false;

    @Inject
    private FeroxRestoreAlertOverlay(FeroxRestoreAlertPlugin plugin, Client client, FeroxRestoreAlertConfig config, OverlayManager overlayManager) {
        super((Plugin)plugin);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.config = config;
        this.overlayManager = overlayManager;
        this.addMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Ferox Restore Alert overlay");
    }

    public void showOverlay() {
        if (!this.isVisible) {
            this.isVisible = true;
            this.overlayManager.add((Overlay)this);
        }
    }

    public void hideOverlay() {
        if (this.isVisible) {
            this.isVisible = false;
            this.overlayManager.remove((Overlay)this);
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.isVisible) {
            return null;
        }
        String titleText = "Restore your stats before leaving!";
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(TitleComponent.builder().text(titleText).color(this.config.getTextColor()).build());
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(titleText) + 50, 20));
        this.panelComponent.setBackgroundColor(this.config.getBackgroundColor());
        switch (this.config.getAlertPosition()) {
            case BOTTOM_LEFT: {
                this.setPosition(OverlayPosition.BOTTOM_LEFT);
                break;
            }
            case TOP_LEFT: {
                this.setPosition(OverlayPosition.TOP_LEFT);
                break;
            }
            case TOP_CENTER: {
                this.setPosition(OverlayPosition.TOP_CENTER);
                break;
            }
            case TOP_RIGHT: {
                this.setPosition(OverlayPosition.TOP_RIGHT);
            }
        }
        return this.panelComponent.render(graphics);
    }
}

