/*
 * Decompiled with CFR 0.152.
 */
package com.mbf;

import com.google.inject.Provides;
import com.mbf.MoreFillConfig;
import com.mbf.MoreFillOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.PostItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="More Bank Fillers")
public class MoreFillPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MoreFillPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MoreFillOverlay overlay;

    protected void startUp() throws Exception {
        this.resetCaches();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.resetCaches();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onPostItemComposition(PostItemComposition event) {
        ItemComposition itemComposition = event.getItemComposition();
        if (itemComposition.getId() == 20594) {
            itemComposition.setInventoryModel(-1);
        }
    }

    @Provides
    MoreFillConfig provideConfig(ConfigManager configManager) {
        return (MoreFillConfig)configManager.getConfig(MoreFillConfig.class);
    }

    private void resetCaches() {
        this.clientThread.invokeLater(() -> {
            this.client.getItemCompositionCache().reset();
            this.client.getItemModelCache().reset();
            this.client.getItemSpriteCache().reset();
        });
    }
}

