/*
 * Decompiled with CFR 0.152.
 */
package com.mbf;

import com.mbf.MoreFillConfig;
import com.mbf.MoreFillOverlayThemes;
import com.mbf.MoreFillOverlayTypes;
import com.mbf.MoreFillPlugin;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreFillOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(MoreFillOverlay.class);
    private final MoreFillConfig config;
    private final BufferedImage empty = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/empty_tile.png");
    private final BufferedImage addydot = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/addy_dot.png");
    private final BufferedImage addysq = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/addy_sq.png");
    private final BufferedImage addyswirl = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/addy_swirl.png");
    private final BufferedImage bronzedot = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/bronze_dot.png");
    private final BufferedImage bronzesq = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/bronze_sq.png");
    private final BufferedImage bronzeswirl = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/bronze_swirl.png");
    private final BufferedImage dragondot = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/dragon_dot.png");
    private final BufferedImage dragonsq = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/dragon_sq.png");
    private final BufferedImage dragonswirl = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/dragon_swirl.png");
    private final BufferedImage golddot = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/gold_dot.png");
    private final BufferedImage goldsq = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/gold_sq.png");
    private final BufferedImage goldswirl = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/gold_swirl.png");
    private final BufferedImage runedot = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/rune_dot.png");
    private final BufferedImage runesq = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/rune_sq.png");
    private final BufferedImage runeswirl = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/rune_swirl.png");
    private final BufferedImage bronzestandard = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/bronze_standard.png");
    private final BufferedImage goldstandard = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/gold_standard.png");
    private final BufferedImage addystandard = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/addy_standard.png");
    private final BufferedImage runestandard = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/rune_standard.png");
    private final BufferedImage dragonstandard = ImageUtil.loadImageResource(MoreFillPlugin.class, (String)"/dragon_standard.png");

    @Inject
    private MoreFillOverlay(MoreFillConfig config) {
        this.config = config;
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (this.config.overlayType() == MoreFillOverlayTypes.EMPTY) {
            return;
        }
        BufferedImage imageToShow = this.getImage(this.config.overlayTheme(), this.config.overlayType());
        if (itemId == 20594) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            graphics.drawImage((Image)imageToShow, (int)bounds.getX(), (int)bounds.getY(), null);
        }
    }

    private BufferedImage getImage(MoreFillOverlayThemes overlayTheme, MoreFillOverlayTypes overlayType) {
        BufferedImage imageToShow = null;
        MoreFillOverlayTypes endType = overlayType;
        MoreFillOverlayThemes endTheme = overlayTheme;
        block0 : switch (endType) {
            case FILLER: {
                switch (endTheme) {
                    case Bronze: {
                        imageToShow = this.bronzestandard;
                        break;
                    }
                    case Gold: {
                        imageToShow = this.goldstandard;
                        break;
                    }
                    case Adamant: {
                        imageToShow = this.addystandard;
                        break;
                    }
                    case Rune: {
                        imageToShow = this.runestandard;
                        break;
                    }
                    case Dragon: {
                        imageToShow = this.dragonstandard;
                    }
                }
                break;
            }
            case SQUARE: {
                switch (endTheme) {
                    case Bronze: {
                        imageToShow = this.bronzesq;
                        break;
                    }
                    case Gold: {
                        imageToShow = this.goldsq;
                        break;
                    }
                    case Adamant: {
                        imageToShow = this.addysq;
                        break;
                    }
                    case Rune: {
                        imageToShow = this.runesq;
                        break;
                    }
                    case Dragon: {
                        imageToShow = this.dragonsq;
                    }
                }
                break;
            }
            case DOT: {
                switch (endTheme) {
                    case Bronze: {
                        imageToShow = this.bronzedot;
                        break;
                    }
                    case Gold: {
                        imageToShow = this.golddot;
                        break;
                    }
                    case Adamant: {
                        imageToShow = this.addydot;
                        break;
                    }
                    case Rune: {
                        imageToShow = this.runedot;
                        break;
                    }
                    case Dragon: {
                        imageToShow = this.dragondot;
                    }
                }
                break;
            }
            case SWIRL: {
                switch (endTheme) {
                    case Bronze: {
                        imageToShow = this.bronzeswirl;
                        break block0;
                    }
                    case Gold: {
                        imageToShow = this.goldswirl;
                        break block0;
                    }
                    case Adamant: {
                        imageToShow = this.addyswirl;
                        break block0;
                    }
                    case Rune: {
                        imageToShow = this.runeswirl;
                        break block0;
                    }
                    case Dragon: {
                        imageToShow = this.dragonswirl;
                    }
                }
            }
        }
        if (imageToShow == null) {
            imageToShow = this.empty;
        }
        return imageToShow;
    }
}

