/*
 * Decompiled with CFR 0.152.
 */
package com.extendedhitsplats.overlays;

import com.extendedhitsplats.ExtendedHitsplatsConfig;
import com.extendedhitsplats.ExtendedHitsplatsPlugin;
import com.extendedhitsplats.HitsplatCategoryEnum;
import com.extendedhitsplats.points.SplatPoints;
import com.extendedhitsplats.utils.Icons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.Point;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class ExtendedHitsplatsOverlay
extends Overlay {
    private final ExtendedHitsplatsPlugin plugin;
    private final ExtendedHitsplatsConfig config;
    private final Client client;

    @Inject
    private ExtendedHitsplatsOverlay(ExtendedHitsplatsPlugin plugin, ExtendedHitsplatsConfig config, Client client) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        List<HitsplatApplied> hitsplatAppliedList = ExtendedHitsplatsPlugin.appliedHitsplatList;
        if (hitsplatAppliedList.size() == 0) {
            return null;
        }
        HashMap<Actor, ArrayList<Hitsplat>> actorListMap = new HashMap<Actor, ArrayList<Hitsplat>>();
        for (HitsplatApplied hitsplatApplied : hitsplatAppliedList) {
            Hitsplat hitsplat = hitsplatApplied.getHitsplat();
            Actor actor = hitsplatApplied.getActor();
            if (actorListMap.containsKey(actor)) {
                ArrayList temp = (ArrayList)actorListMap.get(actor);
                temp.add(hitsplat);
                actorListMap.put(actor, temp);
                continue;
            }
            actorListMap.put(actor, new ArrayList<Hitsplat>(Arrays.asList(hitsplat)));
        }
        for (Actor actor : actorListMap.keySet()) {
            ArrayList hitsplats = (ArrayList)actorListMap.get(actor);
            HitsplatCategoryEnum hitsplatCategoryEnumConfig = this.config.hitsplatCategoryEnum();
            switch (hitsplatCategoryEnumConfig) {
                case Every_Hitsplat: {
                    this.drawExtendedHitsplats(graphics, actor, hitsplats);
                    break;
                }
                case Single_Normal: 
                case Single_BIG: {
                    this.drawSingleHitsplat(graphics, actor, hitsplats, hitsplatCategoryEnumConfig);
                }
            }
        }
        return null;
    }

    private void drawExtendedHitsplats(Graphics2D graphics, Actor actor, List<Hitsplat> hitsplats) {
        int missOffset = 0;
        for (Hitsplat hitsplat : hitsplats) {
            BufferedImage hitsplatImage;
            Point cPoint;
            int idx = hitsplats.indexOf(hitsplat);
            int position = idx - missOffset;
            int damage = hitsplat.getAmount();
            int hitsplatType = hitsplat.getHitsplatType();
            if (position >= this.config.maxHitsplats()) continue;
            if (damage == 0 & this.config.removeZeros()) {
                ++missOffset;
                continue;
            }
            if (this.config.hitsplat2010()) {
                damage *= 10;
            }
            if ((cPoint = actor.getCanvasImageLocation(hitsplatImage = this.drawHitsplat(hitsplatType, damage, FontManager.getRunescapeSmallFont()), actor.getLogicalHeight() / 2)) == null) continue;
            Point p = new Point(cPoint.getX() + 1, cPoint.getY() - 1);
            Point k = SplatPoints.splatPoints.get(position);
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(p.getX() + k.getX(), p.getY() + k.getY()), (BufferedImage)hitsplatImage);
        }
    }

    private void drawSingleHitsplat(Graphics2D graphics, Actor actor, List<Hitsplat> hitsplats, HitsplatCategoryEnum hitsplatCategoryEnum) {
        int damage = 0;
        for (Hitsplat hitsplat : hitsplats) {
            if (hitsplat.getHitsplatType() == 6) continue;
            damage += hitsplat.getAmount();
        }
        if (damage == 0 & this.config.removeZeros()) {
            return;
        }
        if (this.config.hitsplat2010()) {
            damage *= 10;
        }
        int hitsplatType = 43;
        Font font = FontManager.getRunescapeSmallFont();
        switch (hitsplatCategoryEnum) {
            case Single_Normal: {
                hitsplatType = 43;
                font = FontManager.getRunescapeSmallFont();
                break;
            }
            case Single_BIG: {
                hitsplatType = -1;
                font = FontManager.getRunescapeBoldFont();
            }
        }
        BufferedImage hitsplatImage = this.drawHitsplat(hitsplatType, damage, font);
        Point cPoint = actor.getCanvasImageLocation(hitsplatImage, actor.getLogicalHeight() / 2);
        if (cPoint == null) {
            return;
        }
        Point p = new Point(cPoint.getX() + 1, cPoint.getY() - 1);
        OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(p.getX(), p.getY()), (BufferedImage)hitsplatImage);
    }

    private BufferedImage drawHitsplat(int hitsplat_type, int damage, Font font) {
        ImageIcon hitIcon;
        switch (hitsplat_type) {
            case 2: {
                hitIcon = Icons.OSRS_POISON_HITSPLAT;
                break;
            }
            case 12: {
                hitIcon = Icons.OSRS_SELF_MISS_HITSPLAT;
                break;
            }
            case 13: {
                hitIcon = Icons.OSRS_OTHER_MISS_HITSPLAT;
                break;
            }
            case 43: {
                hitIcon = Icons.OSRS_MAX_HITSPLAT;
                break;
            }
            case 16: {
                hitIcon = Icons.OSRS_SELF_DAMAGE_HITSPLAT;
                break;
            }
            case 44: {
                hitIcon = Icons.OSRS_MAX_SHIELD_HITSPLAT;
                break;
            }
            case 45: {
                hitIcon = Icons.OSRS_MAX_ARMOUR_HITSPLAT;
                break;
            }
            case 47: {
                hitIcon = Icons.OSRS_MAX_UNCHARGE_HITSPLAT;
                break;
            }
            case 46: {
                hitIcon = Icons.OSRS_MAX_CHARGE_HITSPLAT;
                break;
            }
            case 18: {
                hitIcon = Icons.OSRS_SELF_SHIELD_HITSPLAT;
                break;
            }
            case 20: {
                hitIcon = Icons.OSRS_SELF_ARMOUR_HITSPLAT;
                break;
            }
            case 24: 
            case 25: {
                hitIcon = Icons.OSRS_SELF_UNCHARGE_HITSPLAT;
                break;
            }
            case 22: {
                hitIcon = Icons.OSRS_SELF_CHARGE_HITSPLAT;
                break;
            }
            case 17: {
                hitIcon = Icons.OSRS_OTHER_DAMAGE_HITSPLAT;
                break;
            }
            case 4: {
                hitIcon = Icons.OSRS_DISEASE_HITSPLAT;
                break;
            }
            case 6: {
                hitIcon = Icons.OSRS_HEAL_HITSPLAT;
                break;
            }
            case 5: {
                hitIcon = Icons.OSRS_VENOM_HITSPLAT;
                break;
            }
            case 19: {
                hitIcon = Icons.OSRS_OTHER_SHIELD_HITSPLAT;
                break;
            }
            case 21: {
                hitIcon = Icons.OSRS_OTHER_ARMOUR_HITSPLAT;
                break;
            }
            case 23: {
                hitIcon = Icons.OSRS_OTHER_CHARGE_HITSPLAT;
                break;
            }
            case 0: {
                hitIcon = Icons.OSRS_CORRUPTION_HITSPLAT;
                break;
            }
            case -1: {
                hitIcon = Icons.OSRS_BIG_HITSPLAT;
                break;
            }
            default: {
                hitIcon = Icons.OSRS_OTHER_POISE_HITSPLAT;
            }
        }
        BufferedImage bi = this.iconToBuffered(hitIcon);
        Graphics g = bi.getGraphics();
        bi = this.drawCenteredDamageNumbers(g, String.valueOf(damage), bi, font);
        g.dispose();
        return bi;
    }

    public BufferedImage drawCenteredDamageNumbers(Graphics g, String text, BufferedImage bi, Font font) {
        FontMetrics metrics = g.getFontMetrics(font);
        int x = (bi.getWidth() - metrics.stringWidth(text)) / 2;
        int y = (bi.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
        g.setFont(font);
        g.setColor(Color.black);
        g.drawString(text, x + 1, y + 1);
        g.setColor(Color.white);
        g.drawString(text, x, y);
        return bi;
    }

    private BufferedImage iconToBuffered(ImageIcon icon) {
        Image image = icon.getImage();
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        Image tempImage = image.getScaledInstance(width, height, 4);
        ImageIcon sizedImageIcon = new ImageIcon(tempImage);
        BufferedImage bi = new BufferedImage(sizedImageIcon.getIconWidth(), sizedImageIcon.getIconHeight(), 2);
        Graphics2D g = bi.createGraphics();
        sizedImageIcon.paintIcon(null, g, 0, 0);
        g.dispose();
        return bi;
    }
}

