/*
 * Decompiled with CFR 0.152.
 */
package com.extendedhitsplats;

import com.extendedhitsplats.ExtendedHitsplatsConfig;
import com.extendedhitsplats.overlays.ExtendedHitsplatsOverlay;
import com.google.inject.Provides;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Extended Hitsplats", description="This plugin will allow you to see more than four hitsplats on a character", enabledByDefault=true, tags={"extended", "hitsplat"})
public class ExtendedHitsplatsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ExtendedHitsplatsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ExtendedHitsplatsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ExtendedHitsplatsOverlay overlay;
    public static List<HitsplatApplied> appliedHitsplatList = new CopyOnWriteArrayList<HitsplatApplied>();

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        log.info("Extended Hitsplats started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("Extended Hitsplats stopped!");
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        appliedHitsplatList.add(hitsplatApplied);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        int clientGameCycle = this.client.getGameCycle();
        if (appliedHitsplatList == null) {
            return;
        }
        if (appliedHitsplatList.size() == 0) {
            return;
        }
        for (HitsplatApplied hitsplatApplied : appliedHitsplatList) {
            int disappear = hitsplatApplied.getHitsplat().getDisappearsOnGameCycle();
            if (clientGameCycle <= disappear) continue;
            appliedHitsplatList.remove(hitsplatApplied);
        }
    }

    @Provides
    ExtendedHitsplatsConfig provideConfig(ConfigManager configManager) {
        return (ExtendedHitsplatsConfig)configManager.getConfig(ExtendedHitsplatsConfig.class);
    }
}

