/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.xpmeter;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.toofifty.xpmeter.Util;
import com.toofifty.xpmeter.XPChart;
import com.toofifty.xpmeter.XPMeterConfig;
import com.toofifty.xpmeter.XPMeterOverlay;
import com.toofifty.xpmeter.XPTracker;
import java.util.HashSet;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="XP Meter", description="Interactive XP/h Meter")
public class XPMeterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(XPMeterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private XPMeterConfig config;
    @Inject
    private XPTracker tracker;
    @Inject
    private XPMeterOverlay overlay;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.syncConfig(null);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        this.tracker.track(event.getSkill(), event.getXp());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.tracker.isPaused()) {
            return;
        }
        this.tracker.tick();
        if (this.tracker.getCurrentTick() % Util.secondsToTicks(this.config.resolution()) == 0) {
            this.update();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN && event.getGameState() != GameState.LOADING && this.tracker.isTracking()) {
            this.tracker.trackLogout();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("xp-meter")) {
            this.syncConfig(event.getKey());
            if (event.getKey().equals("enableDataMenuOptions")) {
                this.overlay.updateMenuEntries(this.config.enableDataMenuOptions());
            }
        }
        if (event.getGroup().equals("runelite") && event.getKey().equals("overlayBackgroundColor")) {
            this.syncConfig(null);
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getOverlay() == this.overlay) {
            if (event.getEntry().getOption().equals("Export data")) {
                this.configManager.setConfiguration("xp-meter", "sessionData", this.tracker.export());
            } else if (event.getEntry().getOption().equals("Restore data")) {
                this.tracker.restore(this.config.sessionData());
            }
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!this.config.scrollZoom()) {
            return;
        }
        if ("scrollWheelZoomIncrement".equals(event.getEventName()) && this.overlay.isMouseOver() && this.client.isKeyPressed(81)) {
            int[] intStack = this.client.getIntStack();
            this.updateScroll(intStack[1]);
            intStack[2] = -intStack[1];
        }
    }

    private void syncConfig(String changedKey) {
        XPChart chart = this.overlay.getChart();
        chart.setSpan(Util.secondsToTicks(this.config.span()));
        chart.setChartHeight(this.config.chartHeight());
        chart.setShowTimeLabels(this.config.showTimeLabels());
        chart.setShowTimeMarkers(this.config.showTimeMarkers());
        chart.setShowXpLabels(this.config.showXpLabels());
        chart.setShowXpMarkers(this.config.showXpMarkers());
        chart.setShowCurrentRates(this.config.showCurrentRates());
        chart.setStackCurrentRates(this.config.stackCurrentRates());
        chart.setShowSkillIcons(this.config.showSkillIcons());
        chart.setLongFormatNumbers(this.config.longFormatNumbers());
        chart.setShowPerformance(this.config.showPerformance());
        chart.setShowHoverTooltips(this.config.showHoverTooltips());
        chart.setDimNonHoveredSkills(this.config.dimNonHoveredSkills());
        chart.setShowAllHovers(this.config.showAllHovers());
        this.overlay.setBackgroundColor(this.config.theme().overlayBackground != null ? this.config.theme().overlayBackground : this.runeLiteConfig.overlayBackgroundColor());
        chart.setTheme(this.config.theme());
        if ("windowInterval".equals(changedKey) || "trackingMode".equals(changedKey)) {
            this.tracker.clearCache();
        }
        if (changedKey == null || changedKey.startsWith("track")) {
            HashSet<Skill> enabledSkills = new HashSet<Skill>();
            for (Skill skill : Skill.values()) {
                Boolean enabled = (Boolean)this.configManager.getConfiguration("xp-meter", "track" + skill.getName(), Boolean.TYPE);
                if (!enabled.booleanValue()) continue;
                enabledSkills.add(skill);
            }
            this.tracker.setEnabledSkills(enabledSkills);
            if (changedKey != null) {
                this.update();
            }
        }
        if ("span".equals(changedKey)) {
            this.update();
        }
    }

    private void update() {
        XPChart chart = this.overlay.getChart();
        chart.setSkillXpHistories(this.tracker.getAggregate(chart.getBounds().width));
        chart.setSortedSkills(this.tracker.getSortedSkills());
        chart.setMaxXpPerHour(this.tracker.getMaxXpPerHour());
        chart.setCurrentTick(this.tracker.getCurrentTick());
        chart.setPauses(this.tracker.getPauses());
        chart.setLogouts(this.tracker.getLogouts());
        chart.setPerformance(this.tracker.getPerformance());
    }

    private void updateScroll(int dir) {
        int span = (int)((double)this.config.span() * Math.pow(1.2, dir));
        this.configManager.setConfiguration("xp-meter", "span", (Object)Math.max(span, 10));
    }

    @Provides
    public XPMeterConfig getConfig(ConfigManager configManager) {
        return (XPMeterConfig)configManager.getConfig(XPMeterConfig.class);
    }
}

