/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.xpmeter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.toofifty.xpmeter.XPChart;
import com.toofifty.xpmeter.XPMeterConfig;
import com.toofifty.xpmeter.XPTracker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Point;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

@Singleton
public class XPMeterOverlay
extends OverlayPanel {
    public static final int DEFAULT_WIDTH = 180;
    public static final int DEFAULT_HEIGHT = 60;
    @Inject
    private XPTracker tracker;
    @Inject
    private Client client;
    private final XPChart chart = new XPChart();
    private boolean isMouseOver = false;

    @Inject
    private XPMeterOverlay(SkillIconManager skillIconManager, XPMeterConfig config) {
        if (this.getPreferredSize() == null) {
            this.setPreferredSize(new Dimension(180, 60));
        }
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setMinimumSize(60);
        this.setResettable(true);
        this.chart.setSkillIconManager(skillIconManager);
        this.addMenuEntry(MenuAction.RUNELITE_OVERLAY, "Reset", "XP Meter", e -> this.tracker.reset());
        this.updateMenuEntries(config.enableDataMenuOptions());
    }

    public void updateMenuEntries(boolean enableDataMenuOptions) {
        this.removeMenuEntry(MenuAction.RUNELITE_OVERLAY, "Pause", "XP Meter");
        this.removeMenuEntry(MenuAction.RUNELITE_OVERLAY, "Unpause", "XP Meter");
        this.addMenuEntry(MenuAction.RUNELITE_OVERLAY, this.tracker != null && this.tracker.isPaused() ? "Unpause" : "Pause", "XP Meter", e -> {
            if (this.tracker.isPaused()) {
                this.tracker.unpause();
            } else {
                this.tracker.pause();
            }
            this.updateMenuEntries(enableDataMenuOptions);
        });
        this.removeMenuEntry(MenuAction.RUNELITE_OVERLAY, "Export data", "XP Meter");
        this.removeMenuEntry(MenuAction.RUNELITE_OVERLAY, "Restore data", "XP Meter");
        if (enableDataMenuOptions) {
            this.addMenuEntry(MenuAction.RUNELITE_OVERLAY, "Export data", "XP Meter");
            this.addMenuEntry(MenuAction.RUNELITE_OVERLAY, "Restore data", "XP Meter");
        }
    }

    public void setBackgroundColor(Color color) {
        this.setPreferredColor(color);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.chart.hasData()) {
            this.panelComponent.getChildren().add(this.chart);
        } else {
            this.panelComponent.getChildren().add(LineComponent.builder().left("XP Meter inactive").build());
        }
        this.isMouseOver = false;
        return super.render(graphics);
    }

    public void onMouseOver() {
        this.isMouseOver = true;
        Rectangle bounds = this.getBounds();
        Point canvas = this.client.getMouseCanvasPosition();
        java.awt.Point mouse = new java.awt.Point(canvas.getX() - bounds.x, canvas.getY() - bounds.y);
        this.chart.setMouse(mouse);
    }

    public XPChart getChart() {
        return this.chart;
    }

    public boolean isMouseOver() {
        return this.isMouseOver;
    }
}

