/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.xpmeter;

import com.toofifty.xpmeter.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public abstract class XPChartBase
implements LayoutableRenderableEntity {
    private Dimension preferredSize;
    private Point preferredLocation;
    protected Graphics2D graphics;
    protected FontMetrics fontMetrics;
    protected int fontHeight;
    protected Rectangle size;
    protected Point offset;
    protected int heightScale;
    protected int widthMax;
    protected int widthMin;

    public Dimension render(Graphics2D g) {
        this.graphics = g;
        this.fontMetrics = g.getFontMetrics();
        this.fontHeight = this.fontMetrics.getHeight();
        int marginLeft = this.calculateLeftMargin();
        int marginRight = this.calculateRightMargin();
        int marginTop = this.calculateTopMargin();
        int marginBottom = this.calculateBottomMargin();
        this.size = this.getBounds();
        Point loc = this.getPreferredLocation();
        this.offset = new Point(loc.x + marginLeft, loc.y + marginTop);
        return new Dimension(marginLeft + this.size.width + marginRight, marginTop + this.size.height + marginBottom);
    }

    protected void setColor(Color color) {
        this.graphics.setColor(color);
    }

    protected void drawText(String text, int x, int y, boolean shadow) {
        if (shadow) {
            Color color = this.graphics.getColor();
            this.graphics.setColor(Color.BLACK);
            this.graphics.drawString(text, this.offset.x + x + 1, this.offset.y + y + 1);
            this.graphics.setColor(color);
        }
        this.graphics.drawString(text, this.offset.x + x, this.offset.y + y);
    }

    protected void drawText(String text, int x, int y) {
        this.drawText(text, x, y, false);
    }

    protected void drawLine(int x1, int y1, int x2, int y2, boolean shadow) {
        if (shadow) {
            Color color = this.graphics.getColor();
            this.graphics.setColor(Color.BLACK);
            this.graphics.drawLine(this.offset.x + x1 + 1, this.offset.y + y1 + 1, this.offset.x + x2 + 1, this.offset.y + y2 + 1);
            this.graphics.setColor(color);
        }
        this.graphics.drawLine(this.offset.x + x1, this.offset.y + y1, this.offset.x + x2, this.offset.y + y2);
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine(x1, y1, x2, y2, false);
    }

    protected void drawRect(int x, int y, int w, int h) {
        this.graphics.drawRect(this.offset.x + x, this.offset.y + y, w, h);
    }

    protected void drawRoundRect(int x, int y, int w, int h, int arc) {
        this.graphics.drawRoundRect(this.offset.x + x, this.offset.y + y, w, h, arc, arc);
    }

    protected void fillRect(int x, int y, int w, int h) {
        this.graphics.fillRect(this.offset.x + x, this.offset.y + y, w, h);
    }

    protected void fillRoundRect(int x, int y, int w, int h, int arc) {
        this.graphics.fillRoundRect(this.offset.x + x, this.offset.y + y, w, h, arc, arc);
    }

    protected void drawVMarker(int x) {
        this.drawLine(x, 0, x, this.size.height);
    }

    protected void drawHMarker(int y) {
        this.drawLine(0, y, this.size.width, y);
    }

    protected void drawImage(BufferedImage image, int x, int y) {
        this.graphics.drawImage((Image)image, this.offset.x + x, this.offset.y + y, null);
    }

    protected void drawThemedTooltip(Theme theme, int x, int y, String label, Color skillColor) {
        if (theme.tooltipBorder != null) {
            this.setColor(theme.tooltipBackground);
            this.fillRect(x - 1, y - this.fontHeight / 2 - 1, this.width(label) + 2, this.fontHeight + 3);
            this.setColor(theme.tooltipBorder);
            this.drawRect(x - 1, y - this.fontHeight / 2 - 1, this.width(label) + 2, this.fontHeight + 3);
            this.setColor(theme.tooltipTextColor);
        } else {
            this.setColor(theme.tooltipBackground);
            this.fillRoundRect(x - 1, y - this.fontHeight / 2 - 1, this.width(label) + 2, this.fontHeight + 2, 2);
            this.setColor(skillColor);
        }
        this.drawText(label, x, y + this.fontHeight / 2, theme.tooltipTextShadow);
    }

    protected int mapX(int x) {
        return (x - this.widthMin) * this.size.width / (this.widthMax - this.widthMin);
    }

    protected int unmapX(int x) {
        return x * (this.widthMax - this.widthMin) / this.size.width + this.widthMin;
    }

    protected int mapY(int y, boolean topMargin) {
        int height = this.size.height;
        int yOffset = 0;
        if (topMargin) {
            height -= this.fontHeight / 2;
            yOffset += this.fontHeight / 2;
        }
        return yOffset + height - y * height / this.heightScale;
    }

    protected int width(String text) {
        return this.fontMetrics.stringWidth(text);
    }

    abstract int calculateLeftMargin();

    abstract int calculateTopMargin();

    abstract int calculateRightMargin();

    abstract int calculateBottomMargin();

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public Point getPreferredLocation() {
        return this.preferredLocation;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setHeightScale(int heightScale) {
        this.heightScale = heightScale;
    }

    public void setWidthMax(int widthMax) {
        this.widthMax = widthMax;
    }

    public void setWidthMin(int widthMin) {
        this.widthMin = widthMin;
    }
}

