/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.xpmeter;

import com.google.common.collect.Lists;
import com.toofifty.xpmeter.Intervals;
import com.toofifty.xpmeter.SkillColor;
import com.toofifty.xpmeter.Theme;
import com.toofifty.xpmeter.Util;
import com.toofifty.xpmeter.XPChartBase;
import com.toofifty.xpmeter.XPTracker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class XPChart
extends XPChartBase
implements LayoutableRenderableEntity {
    public static final int MIN_WIDTH = 60;
    public static final int SKILL_ICON_WIDTH = 16;
    private static final int TIME_LABEL_TPAD = 2;
    private static final int TIME_LABEL_SPACING = 4;
    private static final int XP_LABEL_RPAD = 2;
    private static final int STACKED_RATE_GAP = 3;
    private static final int XP_TOOLTIP_LPAD = 8;
    private static final Color PAUSE_MARKER_COLOR = new Color(0, 166, 255, 128);
    private static final Color LOGOUT_MARKER_COLOR = new Color(255, 68, 0, 128);
    private static final Color CURSOR_MARKER_COLOR = new Color(255, 255, 255, 128);
    private SkillIconManager skillIconManager;
    private Map<Skill, List<Point>> skillXpHistories = null;
    private List<Skill> sortedSkills = null;
    private int maxXpPerHour = 0;
    private int currentTick = 0;
    private Set<Integer> pauses = null;
    private Set<Integer> logouts = null;
    private XPTracker.Performance performance;
    private Point mouse = null;
    private int span = Util.secondsToTicks(180);
    private int chartHeight = 60;
    private boolean showTimeLabels = true;
    private boolean showTimeMarkers = true;
    private boolean showXpLabels = true;
    private boolean showXpMarkers = true;
    private boolean showCurrentRates = true;
    private boolean stackCurrentRates = false;
    private boolean showSkillIcons = true;
    private boolean longFormatNumbers = false;
    private boolean showPerformance = false;
    private boolean showHoverTooltips = true;
    private boolean dimNonHoveredSkills = true;
    private boolean showAllHovers = false;
    private Theme theme = Theme.RUNELITE;
    private Skill hoveredSkill = null;

    public boolean hasData() {
        return this.currentTick > 0 && this.maxXpPerHour > 0;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.hasData()) {
            return new Dimension(0, 0);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Dimension dimension = super.render(graphics);
        this.setHeightScale(this.maxXpPerHour);
        this.setWidthMin(Math.max(this.currentTick - this.span, 0));
        this.setWidthMax(this.currentTick);
        this.setColor(this.theme.chartBackground);
        this.fillRect(0, 0, this.size.width, this.size.height);
        this.setColor(this.theme.chartBorder);
        this.drawRect(0, 0, this.size.width, this.size.height);
        this.drawXpLabels();
        this.drawTimeLabels();
        this.drawHistoryPlot();
        this.drawCurrentRates();
        this.drawPauses();
        this.drawPerformance();
        this.drawMouseOver();
        return dimension;
    }

    private void drawXpLabels() {
        List<Integer> xpIntervals = Intervals.getXpIntervals(this.maxXpPerHour);
        if (this.showXpLabels) {
            int lastY = 0;
            this.setColor(this.theme.axisLabelColor);
            for (Integer xp : Lists.reverse(xpIntervals)) {
                if (xp == 0) continue;
                String label = Util.shortFormat(xp);
                int x = -this.width(label) - 2;
                int y = this.mapY(xp, true) + this.fontHeight / 2;
                if (y - this.fontHeight <= lastY) continue;
                this.drawText(label, x, y, this.theme.axisLabelShadow);
                lastY = y;
            }
        }
        if (this.showXpMarkers) {
            this.setColor(this.theme.horizonalMarkerColor);
            for (Integer xp : xpIntervals) {
                this.drawHMarker(this.mapY(xp, true));
            }
        }
    }

    private void drawTimeLabels() {
        List<Integer> timeIntervals = Intervals.getTimeIntervals(Math.max(this.currentTick - this.span, 0), this.currentTick);
        int originX = Integer.MIN_VALUE;
        Integer origin = timeIntervals.remove(0);
        int y = this.size.height + this.fontHeight + 2;
        if (this.showTimeLabels) {
            this.setColor(this.theme.axisLabelColor);
            String time = Util.ticksToTime(origin);
            int width = this.width(time);
            int x = this.mapX(origin) - width / 2;
            this.drawText(time, x, y, this.theme.axisLabelShadow);
            originX = x + width + 4;
            int lastX = Integer.MAX_VALUE;
            for (Integer timeTick : Lists.reverse(timeIntervals)) {
                String time2 = Util.ticksToTime(timeTick);
                int width2 = this.width(time2);
                int x2 = this.mapX(timeTick) - width2 / 2;
                if (x2 + width2 >= lastX || x2 <= originX) continue;
                this.drawText(time2, x2, y, this.theme.axisLabelShadow);
                lastX = x2 - 4;
            }
        }
        if (this.showTimeMarkers) {
            this.setColor(this.theme.verticalMarkerColor);
            for (Integer timeTick : timeIntervals) {
                this.drawVMarker(this.mapX(timeTick));
            }
        }
    }

    private void drawCurrentRates() {
        if (!this.showCurrentRates && !this.showSkillIcons) {
            return;
        }
        int baseX = this.size.width + this.theme.rateMargin;
        int lastY = this.size.height;
        for (Skill skill : this.sortedSkills) {
            Color skillColor = this.getSkillColor(skill);
            List<Point> history = this.skillXpHistories.get(skill);
            Point last = history.get(history.size() - 1);
            if (last == null || last.getY() == 0.0) continue;
            String rate = this.format(last.y);
            int y = this.mapY(last.y, true);
            int x = baseX;
            int boxHeight = this.fontHeight + 2;
            if (y + boxHeight / 2 + 3 > lastY) {
                y = lastY - boxHeight / 2 - 3;
            }
            if (this.stackCurrentRates && !this.showSkillIcons) {
                lastY = y - this.fontHeight / 2;
            }
            if (this.showSkillIcons) {
                BufferedImage icon = this.skillIconManager.getSkillImage(skill, true);
                if (y + icon.getHeight() / 2 > lastY) {
                    y = lastY - icon.getHeight() / 2;
                }
                if (this.stackCurrentRates) {
                    lastY = y - icon.getHeight() / 2;
                }
                x += icon.getWidth() + this.theme.rateMargin;
                this.drawImage(icon, baseX, y - icon.getHeight() / 2);
            }
            if (!this.showCurrentRates) continue;
            int padding = this.theme.ratePadding;
            x += padding;
            if (this.theme.rateOuterBorder != null) {
                this.setColor(this.theme.rateBackground);
                this.fillRoundRect(x - padding, y - boxHeight / 2, this.width(rate) + padding * 2, boxHeight, 4);
                this.setColor(this.theme.rateInnerBorder);
                this.drawRoundRect(x - padding, y - boxHeight / 2, this.width(rate) + padding * 2, boxHeight, 4);
                this.setColor(this.theme.rateOuterBorder);
                this.drawRoundRect(x - padding - 1, y - boxHeight / 2 - 1, this.width(rate) + padding * 2 + 2, boxHeight + 2, 5);
                this.setColor(this.theme.rateTextColor);
            } else {
                this.setColor(this.theme.rateBackground);
                this.fillRoundRect(x - padding, y - boxHeight / 2, this.width(rate) + padding * 2, boxHeight, 2);
                this.setColor(skillColor);
            }
            this.drawText(rate, x, y + this.fontHeight / 2, true);
        }
    }

    private void drawHistoryPlot() {
        for (Skill skill : this.sortedSkills) {
            this.setColor(this.getSkillColor(skill));
            boolean isFlatlining = false;
            Point prev = null;
            for (Point point : this.skillXpHistories.get(skill)) {
                int x = this.mapX(point.x);
                int y = this.mapY(point.y, true);
                boolean bl = isFlatlining = prev != null && point.getY() == 0.0 && prev.y == y;
                if (prev != null && !isFlatlining) {
                    this.drawLine(prev.x, prev.y, x, y, this.theme.plotShadow);
                }
                prev = new Point(x, y);
            }
            if (prev == null || isFlatlining) continue;
            this.drawLine(prev.x, prev.y, this.size.width, prev.y, this.theme.plotShadow);
        }
    }

    public void drawPauses() {
        int x;
        this.setColor(PAUSE_MARKER_COLOR);
        for (Integer tick : this.pauses) {
            x = this.mapX(tick);
            if (x < 0) continue;
            this.drawVMarker(x);
        }
        this.setColor(LOGOUT_MARKER_COLOR);
        for (Integer tick : this.logouts) {
            x = this.mapX(tick);
            if (x < 0) continue;
            this.drawVMarker(x);
        }
    }

    private void drawPerformance() {
        if (!this.showPerformance) {
            return;
        }
        String time = this.performance.getComputeTime() == 0L ? "<1" : "" + this.performance.getComputeTime();
        String text = time + "ms Cached: " + this.performance.getCacheSize() + " Hits: " + this.performance.getCacheHits() + " Misses: " + this.performance.getCacheMisses() + " Resolution: " + this.performance.getRenderedResolution() + "s ";
        int y = this.size.height + this.fontHeight + 2 + (this.showTimeLabels ? this.fontHeight + 2 : 0);
        if (this.performance.getComputeTime() > 30L) {
            this.setColor(Color.RED);
        } else if (this.performance.getComputeTime() > 10L) {
            this.setColor(Color.ORANGE);
        } else if (this.performance.getComputeTime() > 4L) {
            this.setColor(Color.YELLOW);
        } else {
            this.setColor(this.theme.axisLabelColor);
        }
        this.drawText(text, 0, y, true);
    }

    public void drawMouseOver() {
        if (this.mouse == null || !this.showHoverTooltips) {
            this.hoveredSkill = null;
            return;
        }
        int mx = this.mouse.x - this.offset.x;
        int my = this.mouse.y - this.offset.y;
        if (mx < 0 || my < 0 || mx > this.size.width || my > this.size.height) {
            this.hoveredSkill = null;
            return;
        }
        int hoveredTick = this.unmapX(mx);
        int x = mx + 8;
        this.setColor(CURSOR_MARKER_COLOR);
        this.drawVMarker(mx);
        int closestY = Integer.MIN_VALUE;
        int closestXp = 0;
        Skill closestSkill = null;
        for (Skill skill : this.skillXpHistories.keySet()) {
            List<Point> history = this.skillXpHistories.get(skill);
            int closestDist = Integer.MAX_VALUE;
            Point closest = null;
            for (Point dataPoint : history) {
                int dist = Math.abs(dataPoint.x - hoveredTick);
                if (dist >= closestDist) continue;
                closestDist = dist;
                closest = dataPoint;
            }
            if (closest == null || closest.y == 0) continue;
            int y = this.mapY(closest.y, true);
            if (Math.abs(y - this.mouse.y) < Math.abs(closestY - this.mouse.y)) {
                closestY = y;
                closestXp = closest.y;
                closestSkill = skill;
            }
            if (!this.showAllHovers) continue;
            String label = skill.getName() + ": " + this.format(closest.y) + "/hr";
            this.drawThemedTooltip(this.theme, x, y, label, this.getSkillColor(skill));
        }
        this.hoveredSkill = closestSkill;
        if (!this.showAllHovers && closestSkill != null) {
            String label = closestSkill.getName() + ": " + this.format(closestXp) + "/hr";
            this.drawThemedTooltip(this.theme, x, closestY, label, this.getSkillColor(closestSkill));
        }
    }

    public Rectangle getBounds() {
        Dimension size = this.getPreferredSize();
        if (size == null) {
            return new Rectangle(180, this.chartHeight);
        }
        return new Rectangle(Math.max(size.width, 60), Math.max(size.height, this.chartHeight));
    }

    @Override
    protected int calculateLeftMargin() {
        int xpLabelWidth = 0;
        if (this.showXpLabels) {
            for (Integer xp : Intervals.getXpIntervals(this.maxXpPerHour)) {
                int width = this.width(Util.shortFormat(xp)) + 2;
                if (width <= xpLabelWidth) continue;
                xpLabelWidth = width;
            }
        }
        int originTimeWidth = this.showTimeLabels ? this.width(Util.ticksToTime(this.currentTick > 6000 ? 6000 : 0)) / 2 : 0;
        return Math.max(xpLabelWidth, originTimeWidth);
    }

    @Override
    protected int calculateTopMargin() {
        return 0;
    }

    @Override
    protected int calculateRightMargin() {
        int currentRateWidth = 0;
        if (this.showCurrentRates || this.showSkillIcons) {
            for (List<Point> rates : this.skillXpHistories.values()) {
                Point last = rates.get(rates.size() - 1);
                if (last == null) continue;
                String text = this.format(last.y);
                int width = 0;
                if (this.showCurrentRates) {
                    width += this.width(text) + this.theme.ratePadding * 2 + this.theme.rateMargin * 2;
                }
                if (this.showSkillIcons) {
                    width += 16 + this.theme.rateMargin;
                }
                if (width <= currentRateWidth) continue;
                currentRateWidth = width;
            }
        }
        int currentTimeWidth = this.showTimeLabels ? this.width(Util.ticksToTime(this.currentTick)) / 2 : 0;
        return Math.max(currentRateWidth, currentTimeWidth);
    }

    @Override
    protected int calculateBottomMargin() {
        return (this.showTimeLabels ? this.fontHeight : 0) + (this.showPerformance ? this.fontHeight + 2 : 0);
    }

    private Color getSkillColor(Skill skill) {
        Color color = SkillColor.get(skill);
        if (this.dimNonHoveredSkills && this.hoveredSkill != null && skill != this.hoveredSkill) {
            return Color.DARK_GRAY;
        }
        return color;
    }

    private String format(int number) {
        return this.longFormatNumbers ? Util.format(number) : Util.shortFormat(number);
    }

    public void setSkillIconManager(SkillIconManager skillIconManager) {
        this.skillIconManager = skillIconManager;
    }

    public void setSkillXpHistories(Map<Skill, List<Point>> skillXpHistories) {
        this.skillXpHistories = skillXpHistories;
    }

    public void setSortedSkills(List<Skill> sortedSkills) {
        this.sortedSkills = sortedSkills;
    }

    public void setMaxXpPerHour(int maxXpPerHour) {
        this.maxXpPerHour = maxXpPerHour;
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public void setPauses(Set<Integer> pauses) {
        this.pauses = pauses;
    }

    public void setLogouts(Set<Integer> logouts) {
        this.logouts = logouts;
    }

    public void setPerformance(XPTracker.Performance performance) {
        this.performance = performance;
    }

    public void setMouse(Point mouse) {
        this.mouse = mouse;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
    }

    public void setShowTimeLabels(boolean showTimeLabels) {
        this.showTimeLabels = showTimeLabels;
    }

    public void setShowTimeMarkers(boolean showTimeMarkers) {
        this.showTimeMarkers = showTimeMarkers;
    }

    public void setShowXpLabels(boolean showXpLabels) {
        this.showXpLabels = showXpLabels;
    }

    public void setShowXpMarkers(boolean showXpMarkers) {
        this.showXpMarkers = showXpMarkers;
    }

    public void setShowCurrentRates(boolean showCurrentRates) {
        this.showCurrentRates = showCurrentRates;
    }

    public void setStackCurrentRates(boolean stackCurrentRates) {
        this.stackCurrentRates = stackCurrentRates;
    }

    public void setShowSkillIcons(boolean showSkillIcons) {
        this.showSkillIcons = showSkillIcons;
    }

    public void setLongFormatNumbers(boolean longFormatNumbers) {
        this.longFormatNumbers = longFormatNumbers;
    }

    public void setShowPerformance(boolean showPerformance) {
        this.showPerformance = showPerformance;
    }

    public void setShowHoverTooltips(boolean showHoverTooltips) {
        this.showHoverTooltips = showHoverTooltips;
    }

    public void setDimNonHoveredSkills(boolean dimNonHoveredSkills) {
        this.dimNonHoveredSkills = dimNonHoveredSkills;
    }

    public void setShowAllHovers(boolean showAllHovers) {
        this.showAllHovers = showAllHovers;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }
}

