/*
 * Decompiled with CFR 0.152.
 */
package com.arceuustimers.controllers;

import com.arceuustimers.ArceuusTimersPlugin;
import com.arceuustimers.controllers.SpellController;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrallController
extends SpellController {
    private static final Logger log = LoggerFactory.getLogger(ThrallController.class);
    private final Client client;
    private boolean iconLock;
    private static final double GAME_TICK = 0.6;
    private static final int VARBIT_DOWN = 0;
    private static final int VARBIT_MANUAL = -1;
    private static final int VARBIT_UP = 1;
    private static final int UNLOCKED = 2;
    private static final double GM_MULTIPLIER = 2.0;
    private static final double M_MULTIPLIER = 1.5;

    public ThrallController(String fileName, double cooldown, String tooltip, InfoBoxManager manager, ArceuusTimersPlugin plugin, Client client) {
        super(fileName, cooldown, tooltip, manager, plugin);
        this.client = client;
        this.iconLock = false;
    }

    @Override
    public void varbitChange(int bit) {
        this.setIconLock(false);
        if (!(bit != 1 && bit != -1 || super.getActive())) {
            double thrallUptime = 0.6 * (double)this.client.getBoostedSkillLevel(Skill.MAGIC);
            if (this.client.getVarbitValue(12868) == 2) {
                thrallUptime *= 2.0;
            } else if (this.client.getVarbitValue(12867) == 2) {
                thrallUptime *= 1.5;
            }
            thrallUptime -= 0.6;
            if (bit == -1) {
                thrallUptime += 3.0;
            }
            super.setCooldown(thrallUptime);
            this.createBox();
        } else if (bit == 0 && super.getActive()) {
            this.removeBox();
        }
    }

    public boolean isIconLocked() {
        return this.iconLock;
    }

    public void setIconLock(boolean iconLock) {
        this.iconLock = iconLock;
    }

    @Override
    protected void createBox() {
        super.createBox();
    }

    @Override
    protected void removeBox() {
        super.removeBox();
    }
}

