/*
 * Decompiled with CFR 0.152.
 */
package com.arceuustimers;

import com.arceuustimers.ArceuusSpell;
import com.arceuustimers.ArceuusTimersConfig;
import com.arceuustimers.ArceuusTimersOverlay;
import com.arceuustimers.controllers.CorruptionController;
import com.arceuustimers.controllers.SpellController;
import com.arceuustimers.controllers.StandardController;
import com.arceuustimers.controllers.ThrallController;
import com.arceuustimers.controllers.VariableTimerController;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Arceuus Timers", description="Arceuus spellbook timers with an alternate design to the 'Timers' plugin.", tags={"timer,arceuus,spellbook,thrall,death charge,arceuus,timers"})
public class ArceuusTimersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ArceuusTimersPlugin.class);
    private final HashMap<ArceuusSpell, SpellController> data = new HashMap();
    private final HashSet<Integer> spellVarbits = new HashSet();
    private boolean shutdownOnInstanceLeave = false;
    private boolean fakeThrallBitNeeded = false;
    private boolean firstInstanceCast = true;
    private static final String TIMERS_PLUGIN = "timers";
    private static final String SHOW_ARCEUUS = "showArceuus";
    private static final String SHOW_ARCEUUS_COOLDOWN = "showArceuusCooldown";
    private static final int VILE_VIGOUR = 12292;
    private static final int OFFERINGS = 12423;
    private static final int DARK_LURE = 12289;
    private static final int VARBIT_MANUAL = -1;
    private static final int VARBIT_UP = 1;
    private static final int VARBIT_DOWN = 0;
    private static final int SOTE_ROOM = 13123;
    private static final int SOTE_ROOM_SHADOW = 13379;
    private static final double NO_TEXT = -1.0;
    private static final double CD_LONG = 61.2;
    private static final double CD_MED = 31.2;
    private static final double CD_SHORT = 10.8;
    private static final double CD_TINY = 6.0;
    private int thrallTest = 0;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ArceuusTimersConfig config;
    @Inject
    private ArceuusTimersOverlay overlay;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    private final Map<String, Runnable> gameMessageIconLockHandlers = new HashMap<String, Runnable>(){
        {
            this.put("You must have a Book of the Dead in your possession to use this spell.", () -> ArceuusTimersPlugin.this.gameMessageIconLockRelease());
            this.put("You do not have enough Fire Runes to cast this spell.", () -> ArceuusTimersPlugin.this.gameMessageIconLockRelease());
            this.put("You do not have enough Cosmic Runes to cast this spell.", () -> ArceuusTimersPlugin.this.gameMessageIconLockRelease());
            this.put("You do not have enough Blood Runes to cast this spell.", () -> ArceuusTimersPlugin.this.gameMessageIconLockRelease());
            this.put("You don't have enough Prayer points to cast that spell.", () -> ArceuusTimersPlugin.this.gameMessageIconLockRelease());
            this.put("You can only cast corruption spells every 30 seconds.", () -> ArceuusTimersPlugin.this.gameMessageCorrLockRelease());
            this.put("You resurrect a lesser ghostly  thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/ghost.png", "Active thrall ( Ghost )"));
            this.put("You resurrect a lesser skeletal thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/skeleton.png", "Active thrall ( Skeleton )"));
            this.put("You resurrect a lesser zombified thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/zombie.png", "Active thrall ( Zombie )"));
            this.put("You resurrect a superior ghostly thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/ghost.png", "Active thrall ( Ghost )"));
            this.put("You resurrect a superior skeletal thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/skeleton.png", "Active thrall ( Skeleton )"));
            this.put("You resurrect a superior zombified thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/zombie.png", "Active thrall ( Zombie )"));
            this.put("You resurrect a greater ghostly thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/ghost.png", "Active thrall ( Ghost )"));
            this.put("You resurrect a greater skeletal thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/skeleton.png", "Active thrall ( Skeleton )"));
            this.put("You resurrect a greater zombified thrall.", () -> ArceuusTimersPlugin.this.modifyThrallData("/zombie.png", "Active thrall ( Zombie )"));
            this.put("Your Ward of Arceuus has expired.", () -> ArceuusTimersPlugin.this.expiredGameMessage(ArceuusSpell.WARD));
            this.put("Your Shadow Veil has faded away.", () -> ArceuusTimersPlugin.this.expiredGameMessage(ArceuusSpell.SHADOW));
            this.put("You have placed a Mark of Darkness upon yourself.", () -> ArceuusTimersPlugin.this.gameMessageMarkOfDarkness());
            this.put("Your Mark of Darkness has faded away.", () -> ArceuusTimersPlugin.this.expiredGameMessage(ArceuusSpell.MARK));
        }
    };
    private final Map<String, Runnable> menuOptionHandlers = new HashMap<String, Runnable>(){
        {
            this.put("Resurrect Lesser Ghost", () -> ArceuusTimersPlugin.this.modifyThrallData("/ghost.png", "Active thrall ( Ghost )"));
            this.put("Resurrect Lesser Skeleton", () -> ArceuusTimersPlugin.this.modifyThrallData("/skeleton.png", "Active thrall ( Skeleton )"));
            this.put("Resurrect Lesser Zombie", () -> ArceuusTimersPlugin.this.modifyThrallData("/zombie.png", "Active thrall ( Zombie )"));
            this.put("Resurrect Superior Ghost", () -> ArceuusTimersPlugin.this.modifyThrallData("/ghost.png", "Active thrall ( Ghost )"));
            this.put("Resurrect Superior Skeleton", () -> ArceuusTimersPlugin.this.modifyThrallData("/skeleton.png", "Active thrall ( Skeleton )"));
            this.put("Resurrect Superior Zombie", () -> ArceuusTimersPlugin.this.modifyThrallData("/zombie.png", "Active thrall ( Zombie )"));
            this.put("Resurrect Greater Ghost", () -> ArceuusTimersPlugin.this.modifyThrallData("/ghost.png", "Active thrall ( Ghost )"));
            this.put("Resurrect Greater Skeleton", () -> ArceuusTimersPlugin.this.modifyThrallData("/skeleton.png", "Active thrall ( Skeleton )"));
            this.put("Resurrect Greater Zombie", () -> ArceuusTimersPlugin.this.modifyThrallData("/zombie.png", "Active thrall ( Zombie )"));
            this.put("Greater Corruption", () -> ArceuusTimersPlugin.this.modifyCorruptionData("/greater.png", "Greater Corruption cooldown"));
            this.put("Lesser Corruption", () -> ArceuusTimersPlugin.this.modifyCorruptionData("/lesser.png", "Lesser Corruption cooldown"));
            this.put("Sinister Offering", () -> ArceuusTimersPlugin.this.modifyOfferingData("/sinister_offering.png", "Sinister Offering cooldown"));
            this.put("Demonic Offering", () -> ArceuusTimersPlugin.this.modifyOfferingData("/demonic_offering.png", "Demonic Offering cooldown"));
        }
    };

    @Provides
    ArceuusTimersConfig provideConfig(ConfigManager configManager) {
        return (ArceuusTimersConfig)configManager.getConfig(ArceuusTimersConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.createSpellControllers();
        this.initialSpellVarbits();
        this.setTimersPlugin(false);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.removeActiveInfoboxes();
        this.setTimersPlugin(true);
    }

    private void setTimersPlugin(boolean state) {
        this.configManager.setConfiguration(TIMERS_PLUGIN, SHOW_ARCEUUS, (Object)state);
        this.configManager.setConfiguration(TIMERS_PLUGIN, SHOW_ARCEUUS_COOLDOWN, (Object)state);
    }

    private void removeActiveInfoboxes() {
        for (ArceuusSpell identifier : ArceuusSpell.values()) {
            SpellController spellController = this.data.get((Object)identifier);
            spellController.shutdown();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateActiveSpells();
    }

    private void updateActiveSpells() {
        for (ArceuusSpell identifier : ArceuusSpell.values()) {
            SpellController spellController = this.data.get((Object)identifier);
            if (!spellController.getActive()) continue;
            spellController.updateTime();
        }
        if (this.client.getVarbitValue(12413) == 1) {
            ++this.thrallTest;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("arceuustimers")) {
            return;
        }
        switch (event.getKey()) {
            case "showDeathChargeActive": {
                this.updateConfigChange(this.config.showDeathChargeActive(), 12411, ArceuusSpell.CHARGE);
                break;
            }
            case "showDeathChargeCooldown": {
                this.updateConfigChange(this.config.showDeathChargeCooldown(), 12138, ArceuusSpell.CHARGE_COOLDOWN);
                break;
            }
            case "showThrall": {
                this.updateConfigChange(this.config.showThrall(), 12413, ArceuusSpell.THRALL);
                break;
            }
            case "showThrallCooldown": {
                this.updateConfigChange(this.config.showThrallCooldown(), 12290, ArceuusSpell.THRALL_COOLDOWN);
                break;
            }
            case "showCorruptionCooldown": {
                this.updateConfigChange(this.config.showCorruptionCooldown(), 12288, ArceuusSpell.CORRUPTION);
                break;
            }
            case "showVileVigourCooldown": {
                this.updateConfigChange(this.config.showVileVigourCooldown(), 12292, ArceuusSpell.VIGOUR);
                break;
            }
            case "showShadowVeil": {
                if (!this.config.showShadowVeilCooldown() && !this.config.showShadowVeil()) {
                    this.updateConfigChange(this.config.showShadowVeilCooldown(), 12291, ArceuusSpell.SHADOW_COOLDOWN);
                    break;
                }
                if (!this.config.showShadowVeilCooldown() && this.config.showShadowVeil()) {
                    this.updateConfigChange(true, 12291, ArceuusSpell.SHADOW_COOLDOWN);
                    this.updateConfigChange(this.config.showShadowVeil(), 12414, ArceuusSpell.SHADOW);
                    break;
                }
                this.updateConfigChange(this.config.showShadowVeil(), 12414, ArceuusSpell.SHADOW);
                break;
            }
            case "showShadowVeilCooldown": {
                if (this.config.showShadowVeil() && !this.config.showShadowVeilCooldown()) {
                    this.updateConfigChange(ArceuusSpell.SHADOW_COOLDOWN);
                    break;
                }
                this.updateConfigChange(this.config.showShadowVeilCooldown(), 12291, ArceuusSpell.SHADOW_COOLDOWN);
                break;
            }
            case "showDarkLureCooldown": {
                this.updateConfigChange(this.config.showDarkLureCooldown(), 12289, ArceuusSpell.LURE);
                break;
            }
            case "showWardOfArceuusCooldown": {
                if (this.config.showWardOfArceuus() && !this.config.showWardOfArceuusCooldown()) {
                    this.updateConfigChange(ArceuusSpell.WARD_COOLDOWN);
                    break;
                }
                this.updateConfigChange(this.config.showWardOfArceuusCooldown(), 12293, ArceuusSpell.WARD_COOLDOWN);
                break;
            }
            case "showWardOfArceuus": {
                this.updateConfigChange(this.config.showWardOfArceuus(), ArceuusSpell.WARD);
                break;
            }
            case "showOfferingsCooldown": {
                this.updateConfigChange(this.config.showOfferingsCooldown(), 12423, ArceuusSpell.OFFERING);
                break;
            }
            case "showMarkTimer": {
                this.updateConfigChange(this.config.showMarkTimer(), ArceuusSpell.MARK);
            }
        }
    }

    private void updateConfigChange(boolean enabled, int bits, ArceuusSpell identifier) {
        if (enabled) {
            this.spellVarbits.add(bits);
        } else {
            this.spellVarbits.remove(bits);
            this.data.get((Object)identifier).shutdown();
        }
    }

    private void updateConfigChange(ArceuusSpell identifier) {
        this.data.get((Object)identifier).shutdown();
    }

    private void updateConfigChange(boolean enabled, ArceuusSpell identifier) {
        if (!enabled) {
            this.data.get((Object)identifier).shutdown();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int varbit = event.getVarbitId();
        SpellController spellController = this.data.get((Object)this.getSpellIdentifier(varbit));
        this.handleSpellVarbitChanges(varbit, spellController, event);
        this.handleThrallIconLock(varbit, event);
        this.handleThrallEdgeCase(varbit, event);
        this.handleThrallInstances(varbit, event);
    }

    private void handleSpellVarbitChanges(int varbit, SpellController spellController, VarbitChanged event) {
        if (!this.spellVarbits.contains(varbit)) {
            return;
        }
        if (this.handleCooldownConfigs(varbit)) {
            spellController.varbitChange(this.client.getVarbitValue(varbit));
        }
        if (varbit == 12293 && event.getValue() == 1 && this.config.showWardOfArceuus()) {
            VariableTimerController ward = (VariableTimerController)this.data.get((Object)ArceuusSpell.WARD);
            ward.nonVarbitChange();
        }
        if (varbit == 12291 && event.getValue() == 1 && this.config.showShadowVeil()) {
            SpellController veil = this.data.get((Object)this.getSpellIdentifier(12414));
            veil.varbitChange(this.client.getVarbitValue(12414));
        }
    }

    private boolean handleCooldownConfigs(int varbit) {
        boolean blockVeilCooldown = this.config.showShadowVeil() && !this.config.showShadowVeilCooldown() && varbit == 12291;
        boolean blockWardCooldown = this.config.showWardOfArceuus() && !this.config.showWardOfArceuusCooldown() && varbit == 12293;
        return !blockVeilCooldown && !blockWardCooldown;
    }

    private void handleThrallIconLock(int varbit, VarbitChanged event) {
        if (varbit != 12290) {
            return;
        }
        ThrallController changeData = (ThrallController)this.data.get((Object)ArceuusSpell.THRALL);
        changeData.setIconLock(false);
        if (event.getValue() != 1) {
            return;
        }
        ThrallController thrallController = (ThrallController)this.data.get((Object)ArceuusSpell.THRALL);
        if (this.client.isInInstancedRegion()) {
            this.shutdownOnInstanceLeave = true;
            this.fakeThrallBitNeeded = true;
        }
        if (this.fakeThrallBitNeeded && this.firstInstanceCast) {
            thrallController.varbitChange(1);
            this.fakeThrallBitNeeded = false;
            this.firstInstanceCast = false;
        } else if (!thrallController.getActive() && this.client.getVarbitValue(12413) == 1) {
            thrallController.varbitChange(-1);
        }
    }

    private void handleThrallEdgeCase(int varbit, VarbitChanged event) {
        if (varbit != 12290) {
            return;
        }
        if (event.getValue() != 1) {
            return;
        }
        if (!this.config.showThrall()) {
            return;
        }
        if (this.client.getVarbitValue(12413) == 0) {
            return;
        }
        ThrallController thrallController = (ThrallController)this.data.get((Object)ArceuusSpell.THRALL);
        if (!thrallController.getActive()) {
            return;
        }
        thrallController.shutdown();
        thrallController.varbitChange(-1);
    }

    private void handleThrallInstances(int varbit, VarbitChanged event) {
        if (varbit != 12413 || event.getValue() != 1) {
            return;
        }
        this.firstInstanceCast = false;
        if (this.shutdownOnInstanceLeave && event.getValue() == 0 && !this.firstInstanceCast) {
            this.shutdownOnInstanceLeave = false;
            this.fakeThrallBitNeeded = false;
        }
    }

    private void gameMessageIconLockRelease() {
        ThrallController thrall = (ThrallController)this.data.get((Object)ArceuusSpell.THRALL);
        thrall.setIconLock(false);
    }

    private void gameMessageCorrLockRelease() {
        CorruptionController corruption = (CorruptionController)this.data.get((Object)ArceuusSpell.CORRUPTION);
        corruption.setIconLock(false);
    }

    private void gameMessageMarkOfDarkness() {
        VariableTimerController mark = (VariableTimerController)this.data.get((Object)ArceuusSpell.MARK);
        mark.nonVarbitChange();
    }

    private void expiredGameMessage(ArceuusSpell spell) {
        VariableTimerController responder = (VariableTimerController)this.data.get((Object)spell);
        responder.chatExpiredResponse();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        message = message.replaceAll("<col=[a-z0-9]+>", "").replaceAll("</col>", "");
        if (!event.getType().equals((Object)ChatMessageType.GAMEMESSAGE)) {
            return;
        }
        Runnable handler = this.gameMessageIconLockHandlers.get(message);
        if (handler != null) {
            handler.run();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOGGED_IN) && this.shutdownOnInstanceLeave) {
            int[] mapRegions = this.client.getMapRegions();
            if (mapRegions == null || mapRegions.length == 0) {
                return;
            }
            if (mapRegions[0] == 13123 || mapRegions[0] == 13379) {
                return;
            }
            ThrallController thrall = (ThrallController)this.data.get((Object)ArceuusSpell.THRALL);
            thrall.setIconLock(false);
            this.shutdownOnInstanceLeave = false;
            thrall.shutdown();
        }
        if (this.client.isInInstancedRegion()) {
            this.firstInstanceCast = true;
        }
    }

    private void modifyThrallData(String fileName, String tooltip) {
        this.gameMessageIconLockRelease();
        ThrallController changeData = (ThrallController)this.data.get((Object)ArceuusSpell.THRALL);
        if (changeData.isIconLocked()) {
            return;
        }
        changeData.setFileName(fileName);
        changeData.setTooltip(tooltip);
        changeData.setIconLock(true);
    }

    private void modifyCorruptionData(String fileName, String tooltip) {
        CorruptionController changeData = (CorruptionController)this.data.get((Object)ArceuusSpell.CORRUPTION);
        if (changeData.isIconLocked()) {
            return;
        }
        changeData.setTooltip(tooltip);
        changeData.setFileName(fileName);
        changeData.setIconLock(true);
    }

    private void modifyOfferingData(String fileName, String tooltip) {
        StandardController changeData = (StandardController)this.data.get((Object)ArceuusSpell.OFFERING);
        changeData.setTooltip(tooltip);
        changeData.setFileName(fileName);
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked cast) {
        String option = cast.getMenuTarget().replaceAll("<col=[a-z0-9]+>", "").replaceAll("</col>", "");
        Runnable handler = this.menuOptionHandlers.get(option);
        if (handler != null) {
            handler.run();
        }
    }

    public ArceuusTimersConfig getConfig() {
        return this.config;
    }

    private ArceuusSpell getSpellIdentifier(int varbit) {
        switch (varbit) {
            case 12413: {
                return ArceuusSpell.THRALL;
            }
            case 12290: {
                return ArceuusSpell.THRALL_COOLDOWN;
            }
            case 12411: {
                return ArceuusSpell.CHARGE;
            }
            case 12138: {
                return ArceuusSpell.CHARGE_COOLDOWN;
            }
            case 12288: {
                return ArceuusSpell.CORRUPTION;
            }
            case 12414: {
                return ArceuusSpell.SHADOW;
            }
            case 12291: {
                return ArceuusSpell.SHADOW_COOLDOWN;
            }
            case 12293: {
                return ArceuusSpell.WARD_COOLDOWN;
            }
            case 12292: {
                return ArceuusSpell.VIGOUR;
            }
            case 12289: {
                return ArceuusSpell.LURE;
            }
            case 12423: {
                return ArceuusSpell.OFFERING;
            }
        }
        return null;
    }

    private void initialSpellVarbits() {
        if (this.config.showDeathChargeActive()) {
            this.spellVarbits.add(12411);
        }
        if (this.config.showDeathChargeCooldown()) {
            this.spellVarbits.add(12138);
        }
        if (this.config.showThrall()) {
            this.spellVarbits.add(12413);
        }
        if (this.config.showThrallCooldown()) {
            this.spellVarbits.add(12290);
        }
        if (this.config.showCorruptionCooldown()) {
            this.spellVarbits.add(12288);
        }
        if (this.config.showShadowVeil()) {
            this.spellVarbits.add(12414);
        }
        if (this.config.showShadowVeilCooldown() || this.config.showShadowVeil()) {
            this.spellVarbits.add(12291);
        }
        if (this.config.showVileVigourCooldown()) {
            this.spellVarbits.add(12292);
        }
        if (this.config.showOfferingsCooldown()) {
            this.spellVarbits.add(12423);
        }
        if (this.config.showDarkLureCooldown()) {
            this.spellVarbits.add(12289);
        }
        if (this.config.showWardOfArceuusCooldown() || this.config.showWardOfArceuus()) {
            this.spellVarbits.add(12293);
        }
    }

    private void createSpellControllers() {
        HashMap<ArceuusSpell, InitialSpellData> initData = new HashMap<ArceuusSpell, InitialSpellData>();
        initData.put(ArceuusSpell.THRALL, new InitialSpellData("/ghost.png", -1.0, "Active thrall ( Ghost )"));
        initData.put(ArceuusSpell.THRALL_COOLDOWN, new InitialSpellData("/thrall_cooldown.png", 10.8, "Thrall cooldown"));
        initData.put(ArceuusSpell.CHARGE, new InitialSpellData("/death_charge.png", -1.0, "Death Charge active"));
        initData.put(ArceuusSpell.CHARGE_COOLDOWN, new InitialSpellData("/death_charge_cooldown.png", 61.2, "Death Charge cooldown"));
        initData.put(ArceuusSpell.SHADOW, new InitialSpellData("/shadow_veil.png", -1.0, "Shadow Veil active"));
        initData.put(ArceuusSpell.SHADOW_COOLDOWN, new InitialSpellData("/shadow_veil_cooldown.png", 31.2, "Shadow Veil cooldown"));
        initData.put(ArceuusSpell.VIGOUR, new InitialSpellData("/vile_vigour.png", 10.8, "Vile Vigour cooldown"));
        initData.put(ArceuusSpell.CORRUPTION, new InitialSpellData("/greater.png", 31.2, "Greater Corruption cooldown"));
        initData.put(ArceuusSpell.WARD, new InitialSpellData("/ward.png", -1.0, "Ward of Arceuus active"));
        initData.put(ArceuusSpell.WARD_COOLDOWN, new InitialSpellData("/ward_cooldown.png", 31.2, "Ward of Arceuus cooldown"));
        initData.put(ArceuusSpell.LURE, new InitialSpellData("/lure.png", 10.8, "Dark Lure cooldown"));
        initData.put(ArceuusSpell.OFFERING, new InitialSpellData("/sinister_offering.png", 6.0, "Sinister Offering cooldown"));
        initData.put(ArceuusSpell.MARK, new InitialSpellData("/mark.png", -1.0, "Mark of Darkness active"));
        for (ArceuusSpell spell : ArceuusSpell.values()) {
            SpellController controller;
            switch (spell) {
                case THRALL: {
                    controller = new ThrallController(((InitialSpellData)initData.get((Object)spell)).getFile(), ((InitialSpellData)initData.get((Object)spell)).getCooldown(), ((InitialSpellData)initData.get((Object)spell)).getTooltip(), this.infoBoxManager, this, this.client);
                    break;
                }
                case WARD: 
                case MARK: 
                case SHADOW: {
                    controller = new VariableTimerController(((InitialSpellData)initData.get((Object)spell)).getFile(), ((InitialSpellData)initData.get((Object)spell)).getCooldown(), ((InitialSpellData)initData.get((Object)spell)).getTooltip(), this.infoBoxManager, this, this.client);
                    break;
                }
                case CORRUPTION: {
                    controller = new CorruptionController(((InitialSpellData)initData.get((Object)spell)).getFile(), ((InitialSpellData)initData.get((Object)spell)).getCooldown(), ((InitialSpellData)initData.get((Object)spell)).getTooltip(), this.infoBoxManager, this);
                    break;
                }
                default: {
                    controller = new StandardController(((InitialSpellData)initData.get((Object)spell)).getFile(), ((InitialSpellData)initData.get((Object)spell)).getCooldown(), ((InitialSpellData)initData.get((Object)spell)).getTooltip(), this.infoBoxManager, this);
                }
            }
            this.data.put(spell, controller);
        }
    }

    private static class InitialSpellData {
        private final String file;
        private final double cooldown;
        private final String tooltip;

        public InitialSpellData(String file, double cooldown, String tooltip) {
            this.file = file;
            this.cooldown = cooldown;
            this.tooltip = tooltip;
        }

        public String getFile() {
            return this.file;
        }

        public double getCooldown() {
            return this.cooldown;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }
}

