/*
 * Decompiled with CFR 0.152.
 */
package com.arceuustimers;

import com.arceuustimers.ArceuusTimersConfig;
import com.arceuustimers.ArceuusTimersPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;

public class ArceuusTimersInfobox
extends InfoBox {
    private final double time;
    private double timeLeft;
    InfoBoxManager manager;
    ArceuusTimersConfig config;
    private static final double GAME_TICK = 0.6;
    private static final double LOW_TIME = 0.175;

    public ArceuusTimersInfobox(BufferedImage image, ArceuusTimersPlugin plugin, double time, InfoBoxManager manager, String tooltip) {
        super(image, (Plugin)plugin);
        this.time = time;
        this.manager = manager;
        this.config = plugin.getConfig();
        this.timeLeft = time;
        this.setTooltip(tooltip);
        this.setImage(image);
        this.setPriority(this.config.arceuusBoxPriority());
    }

    public void decreaseByGameTick() {
        this.timeLeft -= 0.6;
    }

    public String getText() {
        if (this.timeLeft < 0.0) {
            return "";
        }
        switch (this.config.textFormat()) {
            case MINUTES: {
                int minutes = (int)(this.timeLeft / 60.0);
                int seconds = (int)(this.timeLeft % 60.0);
                return String.format("%d:%02d", minutes, seconds);
            }
            case GAME_TICKS: {
                return "" + (int)(this.timeLeft / 0.6);
            }
        }
        return "" + (int)this.timeLeft;
    }

    public Color getTextColor() {
        if (this.timeLeft <= this.time * 0.175) {
            return this.config.lowTimeTextColour();
        }
        return this.config.textColour();
    }

    public boolean render() {
        return true;
    }

    public boolean cull() {
        return false;
    }
}

