/*
 * Decompiled with CFR 0.152.
 */
package com.coalbagplugin;

import com.coalbagplugin.CoalBag;
import com.coalbagplugin.CoalBagConfig;
import com.coalbagplugin.CoalBagOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Coal Bag", description="Shows how much coal is in the coal bag.", tags={"coal", "bag"})
public class CoalBagPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CoalBagPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CoalBagOverlay coalBagOverlay;

    @Provides
    CoalBagConfig provideConfig(ConfigManager configManager) {
        return (CoalBagConfig)configManager.getConfig(CoalBagConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.coalBagOverlay);
        CoalBag.setUnknownAmount();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.coalBagOverlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE) {
            CoalBag.updateAmount(event.getMessage());
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Widget coalBagWidget = this.client.getWidget(12648450);
        if (coalBagWidget != null) {
            CoalBag.updateAmount(coalBagWidget.getText());
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if ("Destroy".equals(event.getMenuOption())) {
            CoalBag.setUnknownAmount();
        }
    }
}

