/*
 * Decompiled with CFR 0.152.
 */
package com.coalbagplugin;

import com.coalbagplugin.CoalBag;
import com.coalbagplugin.CoalBagConfig;
import com.google.common.collect.ImmutableList;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

public class CoalBagOverlay
extends WidgetItemOverlay {
    private final CoalBagConfig config;
    private static final Collection<Integer> COAL_BAG_IDS = ImmutableList.of((Object)24480, (Object)764, (Object)12019, (Object)25627);

    @Inject
    private CoalBagOverlay(CoalBagConfig config) {
        this.config = config;
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (COAL_BAG_IDS.contains(itemId)) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            TextComponent textComponent = new TextComponent();
            textComponent.setPosition(new Point(bounds.x - 1, bounds.y + 8));
            if (CoalBag.isUnknown()) {
                textComponent.setColor(this.config.unknownCoalBagColor());
                textComponent.setText("?");
            } else if (CoalBag.isEmpty()) {
                textComponent.setColor(this.config.emptyCoalBagColor());
                textComponent.setText("0");
            } else {
                textComponent.setColor(this.config.knownCoalBagColor());
                textComponent.setText(CoalBag.getAmount());
            }
            textComponent.render(graphics);
        }
    }
}

