/*
 * Decompiled with CFR 0.152.
 */
package com.coalbagplugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoalBag {
    private static final int UNKNOWN_AMOUNT = -1;
    private static final int EMPTY_AMOUNT = 0;
    private static final Pattern BAG_EMPTY_MESSAGE = Pattern.compile("^The coal bag is (?:now\\s)?empty\\.");
    private static final Pattern BAG_ONE_OR_MANY_MESSAGE = Pattern.compile("^The coal bag (?:still\\s)?contains ([\\d]+|one) pieces? of coal\\.");
    private static int storedAmount;

    private static void setAmount(int amount) {
        storedAmount = amount;
    }

    private static void setEmptyAmount() {
        storedAmount = 0;
    }

    public static void setUnknownAmount() {
        storedAmount = -1;
    }

    public static String getAmount() {
        return String.valueOf(storedAmount);
    }

    public static void updateAmount(String message) {
        Matcher emptyMatcher = BAG_EMPTY_MESSAGE.matcher(message);
        if (emptyMatcher.matches()) {
            CoalBag.setEmptyAmount();
        } else {
            Matcher oneOrManyMatcher = BAG_ONE_OR_MANY_MESSAGE.matcher(message);
            if (oneOrManyMatcher.matches()) {
                String match = oneOrManyMatcher.group(1);
                if (match.equals("one")) {
                    CoalBag.setAmount(1);
                } else {
                    CoalBag.setAmount(Integer.parseInt(match));
                }
            }
        }
    }

    public static boolean isUnknown() {
        return storedAmount == -1;
    }

    public static boolean isEmpty() {
        return storedAmount == 0;
    }
}

