/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.ui;

import com.pickpockethelper.PickpocketHelperConfig;
import com.pickpockethelper.PickpocketHelperPlugin;
import com.pickpockethelper.entity.Session;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TimerOverlay
extends OverlayPanel {
    private final Client client;
    private final PickpocketHelperConfig config;
    private final Session session;

    @Inject
    private TimerOverlay(Client client, PickpocketHelperPlugin plugin, PickpocketHelperConfig config, Session session) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.session = session;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        NPC target = this.session.getTarget().getNpc();
        if (target == null || !this.config.enableDespawnTimer() || this.client.isInInstancedRegion() || !this.session.getTarget().isRendered()) {
            return null;
        }
        int displayedAmount = this.session.getTarget().getSecondsBeforeDespawn();
        if (displayedAmount < 0) {
            return null;
        }
        Point timerLocation = target.getCanvasTextLocation(graphics, String.valueOf(displayedAmount), target.getLogicalHeight() + 25);
        Color textColor = displayedAmount > 30 ? Color.white : Color.RED;
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)timerLocation, (String)String.valueOf(displayedAmount), (Color)textColor);
        return null;
    }
}

