/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.ui;

import com.pickpockethelper.PickpocketHelperConfig;
import com.pickpockethelper.PickpocketHelperPlugin;
import com.pickpockethelper.entity.Session;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class StatusOverlay
extends OverlayPanel {
    private final PickpocketHelperConfig config;
    private final Session session;

    @Inject
    private StatusOverlay(PickpocketHelperPlugin plugin, PickpocketHelperConfig config, Session session) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.config = config;
        this.session = session;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.session.getLastPickpocketAttempt() == null || !this.config.enableStatusOverlay()) {
            return null;
        }
        if (!this.session.isPickpocketing(Duration.ofSeconds(30L))) {
            return null;
        }
        if (this.session.isPickpocketing(Duration.ofSeconds(6L))) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Pickpocketing").color(Color.GREEN).build());
        } else {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("NOT pickpocketing").color(Color.RED).build());
        }
        return super.render(graphics);
    }
}

