/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.ui;

import com.pickpockethelper.PickpocketHelperConfig;
import com.pickpockethelper.PickpocketHelperPlugin;
import com.pickpockethelper.entity.Session;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class StatisticOverlay
extends OverlayPanel {
    private final PickpocketHelperConfig config;
    private final Session session;

    @Inject
    private StatisticOverlay(PickpocketHelperPlugin plugin, PickpocketHelperConfig config, Session session) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.config = config;
        this.session = session;
    }

    public Dimension render(Graphics2D graphics) {
        int perHourCount;
        if (this.session.getLastPickpocketAttempt() == null || this.session.getSessionStart() == null || !this.config.enableStatsOverlay()) {
            return null;
        }
        if (!this.session.isPickpocketing(Duration.ofSeconds(30L))) {
            return null;
        }
        Integer failCount = this.session.getPickpocketFailCount();
        Integer successCount = this.session.getPickpocketSuccessCount();
        int totalCount = failCount + successCount;
        long secondsSinceSessionStart = Duration.between(this.session.getSessionStart(), Instant.now()).getSeconds();
        int n = perHourCount = successCount < 1 ? 0 : Math.round((float)successCount.intValue() / (float)secondsSinceSessionStart * 3600.0f);
        int failRatio = totalCount == 0 ? 0 : (failCount == 0 ? 0 : Math.round((float)failCount.intValue() / (float)totalCount * 100.0f));
        int successRatio = 100 - failRatio;
        this.panelComponent.getChildren().add(LineComponent.builder().left("Picked:").right(String.valueOf(successCount)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Rate:").right(successRatio + "%").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Per hour:").right(String.valueOf(perHourCount)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Failed:").right(String.valueOf(failCount)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Rate:").right(failRatio + "%").build());
        return super.render(graphics);
    }
}

