/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.ui;

import com.pickpockethelper.PickpocketHelperConfig;
import com.pickpockethelper.PickpocketHelperPlugin;
import com.pickpockethelper.entity.Session;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.api.Player;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class SplasherOverlay
extends OverlayPanel {
    private final PickpocketHelperConfig config;
    private final Session session;

    @Inject
    private SplasherOverlay(PickpocketHelperPlugin plugin, PickpocketHelperConfig config, Session session) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.config = config;
        this.session = session;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.session.getLastPickpocketAttempt() == null || !this.config.enableSplasherOverlay()) {
            return null;
        }
        if (!this.session.isPickpocketing(Duration.ofSeconds(30L))) {
            return null;
        }
        Player player = this.session.getSplasher().getPlayer();
        if (player == null) {
            this.panelComponent.getChildren().add(TitleComponent.builder().color(Color.RED).text("NO Splasher").build());
            return super.render(graphics);
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left("Name:").right(player.getName()).build());
        boolean isAttacking = this.session.getSplasher().isAttacking();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Status:").right(isAttacking ? "Splashing" : "Idle").rightColor(isAttacking ? Color.GREEN : Color.RED).build());
        return super.render(graphics);
    }
}

