/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.entity;

import com.pickpockethelper.entity.Session;
import com.pickpockethelper.utility.Helper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.runelite.api.Actor;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

public class Target {
    private final Session session;
    private NPC npc;
    private final List<Runnable> npcListeners = new ArrayList<Runnable>();
    private WorldPoint lastLocation;
    private Instant lastMove;
    private Instant lastDespawnNotify;

    public Target(Session session) {
        this.session = session;
    }

    public void setNpc(NPC npc) {
        if (this.npc != null && this.session.isTarget((Actor)npc)) {
            return;
        }
        boolean similarTarget = this.npc != null && (this.npc.getIndex() == npc.getIndex() || Objects.equals(npc.getName(), this.npc.getName()));
        this.npc = npc;
        this.lastLocation = npc.getWorldLocation();
        if (!similarTarget) {
            this.session.reset();
        }
        this.npcListeners.forEach(Runnable::run);
    }

    public void updateLocation(WorldPoint location) {
        this.lastMove = Instant.now();
        this.lastLocation = location;
    }

    public void updateLastDespawnNotify() {
        this.lastDespawnNotify = Instant.now();
    }

    public void addNpcListener(Runnable runnable) {
        this.npcListeners.add(runnable);
    }

    public boolean isRendered() {
        return Helper.isRendered((Actor)this.npc);
    }

    public int getSecondsBeforeDespawn() {
        int secondsBeforeDespawn;
        if (this.lastMove == null) {
            return -1;
        }
        int secondsSinceLastMove = Helper.secondsSince(this.lastMove);
        Integer secondsSinceLastAttackReceived = this.session.getSplasher().getLastAttack() != null ? Integer.valueOf(Helper.secondsSince(this.session.getSplasher().getLastAttack())) : null;
        int n = secondsBeforeDespawn = secondsSinceLastAttackReceived == null || secondsSinceLastMove < secondsSinceLastAttackReceived ? 300 - secondsSinceLastMove : 300 - secondsSinceLastAttackReceived;
        if (secondsBeforeDespawn == 300) {
            this.lastDespawnNotify = null;
        }
        return secondsBeforeDespawn;
    }

    public void clear() {
        this.npcListeners.clear();
        this.npc = null;
        this.lastLocation = null;
        this.lastMove = null;
        this.lastDespawnNotify = null;
    }

    public NPC getNpc() {
        return this.npc;
    }

    public WorldPoint getLastLocation() {
        return this.lastLocation;
    }

    public Instant getLastMove() {
        return this.lastMove;
    }

    public Instant getLastDespawnNotify() {
        return this.lastDespawnNotify;
    }
}

