/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.entity;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Player;

public class Splasher {
    private Player player;
    private Instant lastAttack;
    private final List<Runnable> isAttackingListeners = new ArrayList<Runnable>();
    private final List<Runnable> playerListeners = new ArrayList<Runnable>();
    private Instant lastIdleNotify;

    public void updatePlayer(Player player) {
        this.player = player;
        this.playerListeners.forEach(Runnable::run);
    }

    public void addPlayerListener(Runnable runnable) {
        this.playerListeners.add(runnable);
    }

    public void updateLastIdleNotify() {
        this.lastIdleNotify = Instant.now();
    }

    public void updateLastAttack() {
        this.lastAttack = Instant.now();
        this.lastIdleNotify = null;
    }

    public void updateIsAttacking() {
        this.isAttackingListeners.forEach(Runnable::run);
    }

    public boolean isAttacking() {
        Duration timeSinceLastAtack = Duration.between(this.lastAttack, Instant.now());
        return timeSinceLastAtack.getSeconds() < 4L;
    }

    public void addIsAttackingListener(Runnable runnable) {
        this.isAttackingListeners.add(runnable);
    }

    public void reset() {
        this.lastAttack = null;
        this.player = null;
        this.lastIdleNotify = null;
    }

    public void clear() {
        this.isAttackingListeners.clear();
        this.playerListeners.clear();
        this.reset();
    }

    public String toString() {
        return this.player.getName();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Instant getLastAttack() {
        return this.lastAttack;
    }

    public Instant getLastIdleNotify() {
        return this.lastIdleNotify;
    }
}

