/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper.entity;

import com.pickpockethelper.entity.Splasher;
import com.pickpockethelper.entity.Target;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.NPC;

@Singleton
public class Session {
    private final Target target;
    private final Splasher splasher;
    private Instant lastPickpocketAttempt;
    private final List<Runnable> lastPickpocketAttemptListeners = new ArrayList<Runnable>();
    private Instant lastPickpocketSuccess;
    private Instant lastPlayerIdleNotify;
    private Instant lastRogueEquipmentProc;
    private Instant lastStun;
    private Integer pickpocketSuccessCount = 0;
    private Integer pickpocketFailCount = 0;
    private Instant sessionStart;

    public Session() {
        this.target = new Target(this);
        this.splasher = new Splasher();
    }

    public void updateLastPickpocketAttempt() {
        this.lastPickpocketAttempt = Instant.now();
        this.lastPickpocketAttemptListeners.forEach(Runnable::run);
    }

    public void addLastPickpocketAttemptListener(Runnable runnable) {
        this.lastPickpocketAttemptListeners.add(runnable);
    }

    public void updateLastPlayerIdleNotify() {
        this.lastPlayerIdleNotify = Instant.now();
    }

    public void updateLastPickpocketSuccess() {
        this.lastPickpocketSuccess = Instant.now();
    }

    public void updateLastRogueEquipmentProc() {
        this.lastRogueEquipmentProc = Instant.now();
    }

    public void updateLastStun() {
        this.lastStun = Instant.now();
    }

    public void increasePickpocketSuccessCount() {
        Integer n = this.pickpocketSuccessCount;
        Integer n2 = this.pickpocketSuccessCount = Integer.valueOf(this.pickpocketSuccessCount + 1);
    }

    public void increasePickpocketFailCount() {
        Integer n = this.pickpocketFailCount;
        Integer n2 = this.pickpocketFailCount = Integer.valueOf(this.pickpocketFailCount + 1);
    }

    public void setupListeners() {
        this.target.addNpcListener(this::onTargetChange);
    }

    private void onTargetChange() {
        this.sessionStart = Instant.now();
    }

    public boolean isPickpocketing(Duration delay) {
        Duration stunDuration;
        if (this.lastPickpocketAttempt == null) {
            return false;
        }
        if (this.lastStun != null && (stunDuration = Duration.between(this.lastStun, Instant.now())).getSeconds() < 6L) {
            delay = delay.plus(Duration.ofSeconds(6L));
        }
        return this.lastPickpocketAttempt.plus(delay).isAfter(Instant.now());
    }

    public boolean isActive() {
        return this.isPickpocketing(Duration.ofSeconds(120L));
    }

    public boolean isTarget(Actor actor) {
        if (this.target.getNpc() == null || !(actor instanceof NPC)) {
            return false;
        }
        return this.target.getNpc().equals(actor);
    }

    public void reset() {
        this.lastPickpocketAttempt = null;
        this.lastPickpocketSuccess = null;
        this.lastRogueEquipmentProc = null;
        this.lastPlayerIdleNotify = null;
        this.lastStun = null;
        this.pickpocketSuccessCount = 0;
        this.pickpocketFailCount = 0;
        this.sessionStart = null;
    }

    public void clear() {
        this.lastPickpocketAttemptListeners.clear();
        this.splasher.clear();
        this.target.clear();
        this.reset();
    }

    public Target getTarget() {
        return this.target;
    }

    public Splasher getSplasher() {
        return this.splasher;
    }

    public Instant getLastPickpocketAttempt() {
        return this.lastPickpocketAttempt;
    }

    public Instant getLastPickpocketSuccess() {
        return this.lastPickpocketSuccess;
    }

    public Instant getLastPlayerIdleNotify() {
        return this.lastPlayerIdleNotify;
    }

    public Instant getLastRogueEquipmentProc() {
        return this.lastRogueEquipmentProc;
    }

    public Instant getLastStun() {
        return this.lastStun;
    }

    public Integer getPickpocketSuccessCount() {
        return this.pickpocketSuccessCount;
    }

    public Integer getPickpocketFailCount() {
        return this.pickpocketFailCount;
    }

    public Instant getSessionStart() {
        return this.sessionStart;
    }
}

