/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.pickpockethelper.AlertManager;
import com.pickpockethelper.AudioManager;
import com.pickpockethelper.FeedbackManager;
import com.pickpockethelper.HighlightManager;
import com.pickpockethelper.PickpocketHelperConfig;
import com.pickpockethelper.entity.Session;
import com.pickpockethelper.ui.SplasherOverlay;
import com.pickpockethelper.ui.StatisticOverlay;
import com.pickpockethelper.ui.StatusOverlay;
import com.pickpockethelper.ui.TimerOverlay;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Hitsplat;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.Skill;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pickpocket Helper", description="Adds quality of life improvements for pickpocketing.", tags={"thieving", "pickpocketing", "ardy", "knights", "master", "farmer", "vyres"})
public class PickpocketHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PickpocketHelperPlugin.class);
    private static final HashMap<String, Runnable> messageTriggers = new HashMap();
    private static final Set<String> blockedPatterns = ImmutableSet.of((Object)"You have no space in your inventory for your loot\\.", (Object)"You need to empty your coin pouches before you can continue pickpocketing\\.", (Object)"I can't reach that!");
    @Inject
    private PickpocketHelperConfig config;
    @Inject
    private Client client;
    @Inject
    private Hooks hooks;
    @Inject
    private HighlightManager highlightManager;
    @Inject
    private FeedbackManager feedbackManager;
    @Inject
    private AlertManager alertManager;
    @Inject
    private AudioManager audioManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private StatisticOverlay statisticOverlay;
    @Inject
    private StatusOverlay statusOverlay;
    @Inject
    private SplasherOverlay splasherOverlay;
    @Inject
    private TimerOverlay timerOverlay;
    @Inject
    private Session session;

    @Provides
    PickpocketHelperConfig provideConfig(ConfigManager configManager) {
        return (PickpocketHelperConfig)configManager.getConfig(PickpocketHelperConfig.class);
    }

    private void setupListeners() {
        this.session.getTarget().addNpcListener(this::onLastPickpocketTargetChanged);
        this.session.getSplasher().addIsAttackingListener(this::onSplasherIsAttackingChanged);
        this.session.getSplasher().addPlayerListener(this::onSplasherChanged);
        this.session.setupListeners();
    }

    private void setupMessageTriggers() {
        messageTriggers.put("Your dodgy necklace protects you\\..*It then crumbles to dust\\.", this::onDodgyNecklaceBreak);
        messageTriggers.put("You've been stunned!", this::onStun);
        messageTriggers.put("Your Shadow Veil has faded away\\.", this::onShadowVeilFade);
        messageTriggers.put("You pick .*\\ pocket\\.", this::onPickpocketSuccess);
        messageTriggers.put("You fail to pick .*\\ pocket\\.", this::onPickpocketFail);
        messageTriggers.put("Your rogue clothing allows you to steal twice as much loot!", this::onRogueEquipmentProc);
        messageTriggers.put("You need to empty your coin pouches before you can continue pickpocketing\\.", this::onPouchesFull);
        messageTriggers.put("You don't have enough inventory space to do that\\.", this::onInventoryFull);
        messageTriggers.put("You have no space in your inventory for your loot\\.", this::onInventoryFull);
        messageTriggers.put("Your gloves of silence are going to fall apart!", this::onGlovesBreak);
    }

    private boolean shouldRenderEntity(Renderable renderable, boolean drawingUI) {
        if (!this.config.enableHideOthers() || !this.session.isPickpocketing(Duration.ofSeconds(10L))) {
            return true;
        }
        if (!(renderable instanceof Actor)) {
            return true;
        }
        Actor actor = (Actor)renderable;
        if (this.session.isTarget(actor) || actor.equals(this.client.getLocalPlayer()) || actor.equals(this.session.getSplasher().getPlayer())) {
            return true;
        }
        if (actor instanceof NPC) {
            NPC npc = (NPC)actor;
            if (npc.getComposition().isFollower()) {
                return this.client.getLocalPlayer().equals(npc.getInteracting());
            }
            return false;
        }
        Player player = (Player)actor;
        return player.isFriend() || player.isClanMember();
    }

    protected void startUp() {
        this.setupListeners();
        this.setupMessageTriggers();
        this.overlayManager.add((Overlay)this.statusOverlay);
        this.overlayManager.add((Overlay)this.splasherOverlay);
        this.overlayManager.add((Overlay)this.statisticOverlay);
        this.overlayManager.add((Overlay)this.timerOverlay);
        this.audioManager.init();
        this.hooks.registerRenderableDrawListener(this::shouldRenderEntity);
    }

    protected void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this::shouldRenderEntity);
        this.highlightManager.clearTargets();
        this.overlayManager.remove((Overlay)this.statusOverlay);
        this.overlayManager.remove((Overlay)this.splasherOverlay);
        this.overlayManager.remove((Overlay)this.statisticOverlay);
        this.overlayManager.remove((Overlay)this.timerOverlay);
        this.audioManager.clear();
        this.session.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged change) {
        switch (change.getGameState()) {
            case LOGIN_SCREEN: {
                this.session.clear();
                this.highlightManager.clearTargets();
                break;
            }
            case LOGGED_IN: {
                this.highlightManager.refresh();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("pickpockethelper")) {
            this.highlightManager.refresh();
            this.overlayManager.resetOverlay((Overlay)this.statisticOverlay);
            this.overlayManager.resetOverlay((Overlay)this.statusOverlay);
            this.overlayManager.resetOverlay((Overlay)this.splasherOverlay);
        }
    }

    @Subscribe
    private void onChatMessage(ChatMessage chatMessage) {
        this.checkAndExecuteChatMessageTriggers(chatMessage);
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!this.config.enableBlockSpam() || !"chatFilterCheck".equals(event.getEventName())) {
            return;
        }
        String message = this.client.getStringStack()[this.client.getStringStackSize() - 1];
        String content = Text.removeTags((String)message);
        blockedPatterns.forEach(pattern -> {
            if (Pattern.compile(pattern).matcher(content).find()) {
                this.client.getIntStack()[this.client.getIntStackSize() - 3] = 0;
            }
        });
    }

    @Subscribe
    private void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        this.checkAndNotifyLowHitpoints(hitsplatApplied.getHitsplat());
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.checkAndNotifyPlayerIdle();
        this.checkAndUpdateTargetLocation();
        this.checkAndNotifyTargetDespawn();
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        this.swapLeftClickPickpocket();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged change) {
        this.checkAndUpdateSplasher(change.getActor());
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        this.checkAndUpdateTargetFromCache(npcSpawned.getNpc());
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffect) {
        this.checkAndMuteSoundEffect(soundEffect);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        this.checkAndUpdatePickpocketAttempt(menuOptionClicked);
    }

    private void checkAndUpdatePickpocketAttempt(MenuOptionClicked menuOptionClicked) {
        if (!menuOptionClicked.getMenuOption().equalsIgnoreCase("Pickpocket")) {
            return;
        }
        this.session.getTarget().setNpc(menuOptionClicked.getMenuEntry().getNpc());
        this.session.updateLastPickpocketAttempt();
        this.session.getSplasher().updateIsAttacking();
    }

    private void onPickpocketSuccess() {
        this.session.updateLastPickpocketSuccess();
        this.session.increasePickpocketSuccessCount();
        this.checkAndNotifyRogueEquipment();
    }

    private void onPickpocketFail() {
        this.session.increasePickpocketFailCount();
    }

    private void onStun() {
        this.session.updateLastStun();
    }

    private void onInventoryFull() {
        this.notifyNoSpace();
    }

    private void onPouchesFull() {
        this.notifyNoSpace();
    }

    private void onLastPickpocketTargetChanged() {
        this.updatePickpocketTargetHighlight();
    }

    private void onSplasherChanged() {
        this.checkAndNotifySplasherFound();
    }

    private void onSplasherIsAttackingChanged() {
        this.checkAndNotifySplasherIdle();
    }

    private void onShadowVeilFade() {
        this.notifyShadowVeilFade();
    }

    private void onGlovesBreak() {
    }

    private void onDodgyNecklaceBreak() {
        this.notifyNecklaceBreak();
    }

    private void onRogueEquipmentProc() {
        this.session.updateLastRogueEquipmentProc();
    }

    private void checkAndNotifySplasherFound() {
        if (this.session.getSplasher().getPlayer() == null) {
            return;
        }
        String message = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Splasher found: ").append(ChatColorType.HIGHLIGHT).append(this.session.getSplasher().getPlayer().getName()).build();
        this.feedbackManager.sendChatMessage(message);
    }

    private void updatePickpocketTargetHighlight() {
        this.highlightManager.clearTargets();
        this.highlightManager.addTarget(this.session.getTarget().getNpc());
    }

    private void checkAndNotifyPlayerIdle() {
        Duration delay = Duration.ofSeconds(this.config.getInactiveNotificationDelay());
        if (delay.isZero() || delay.isNegative() || this.session.getLastPlayerIdleNotify() != null) {
            return;
        }
        if (this.session.getLastPickpocketAttempt() != null && !this.session.isPickpocketing(delay)) {
            this.session.updateLastPlayerIdleNotify();
            this.alertManager.sendAlert(3, false);
        }
    }

    private void checkAndNotifySplasherIdle() {
        if (!this.config.enableIdleSplasherNotification() || this.session.getSplasher().getLastIdleNotify() != null || this.session.getSplasher().getPlayer() == null || this.session.getSplasher().isAttacking()) {
            return;
        }
        this.session.getSplasher().updateLastIdleNotify();
        this.alertManager.sendAlert(6, true);
    }

    private void checkAndNotifyRogueEquipment() {
        Duration timeSinceLastProc;
        if (!this.config.enableRogueEquipmentNotification()) {
            return;
        }
        if (this.session.getLastPickpocketSuccess() != null && this.session.getLastRogueEquipmentProc() != null && (timeSinceLastProc = Duration.between(this.session.getLastRogueEquipmentProc(), Instant.now())).getSeconds() < 3L) {
            return;
        }
        int[] equipedGearIds = this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds();
        HashSet<Integer> adjustedGearIds = new HashSet<Integer>();
        for (int equipmentId : equipedGearIds) {
            if (equipmentId < 512) continue;
            adjustedGearIds.add(equipmentId - 512);
        }
        HashSet<Integer> rogueEquipmentIds = new HashSet<Integer>(Arrays.asList(5557, 5556, 5554, 5553, 5555));
        if (!adjustedGearIds.containsAll(rogueEquipmentIds)) {
            this.alertManager.sendAlert(4, true);
        }
    }

    private void notifyNoSpace() {
        if (!this.config.enableNoSpaceNotification()) {
            return;
        }
        this.alertManager.sendAlert(2, false);
    }

    private void notifyGlovesBreak() {
        if (!this.config.enableGlovesNotification()) {
            return;
        }
        this.alertManager.sendAlert(8, false);
    }

    private void notifyNecklaceBreak() {
        if (!this.config.enableNecklaceNotification()) {
            return;
        }
        this.alertManager.sendAlert(0, false);
    }

    private void notifyShadowVeilFade() {
        if (!this.config.enableShadowVeilNotification()) {
            return;
        }
        this.alertManager.sendAlert(5, false);
    }

    private void checkAndNotifyLowHitpoints(Hitsplat hitsplat) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.config.getHitpointsThreshold() < 1 || !hitsplat.isMine()) {
            return;
        }
        int hitpoints = this.client.getBoostedSkillLevel(Skill.HITPOINTS) - hitsplat.getAmount();
        if (hitpoints <= this.config.getHitpointsThreshold()) {
            this.alertManager.sendAlert(1, true);
        }
    }

    private void checkAndNotifyTargetDespawn() {
        int targetDespawnThreshold = this.config.getTargetDespawnThreshold();
        if (this.client.getGameState() != GameState.LOGGED_IN || this.session.getTarget().getLastDespawnNotify() != null || targetDespawnThreshold == 0 || this.session.getTarget().getNpc() == null || !this.session.getTarget().isRendered()) {
            return;
        }
        int secondsBeforeDespawn = this.session.getTarget().getSecondsBeforeDespawn();
        if (secondsBeforeDespawn <= targetDespawnThreshold && secondsBeforeDespawn > 0) {
            this.session.getTarget().updateLastDespawnNotify();
            this.alertManager.sendAlert(7, true);
        }
    }

    private void checkAndExecuteChatMessageTriggers(ChatMessage message) {
        if (message.getType() != ChatMessageType.GAMEMESSAGE && message.getType() != ChatMessageType.SPAM) {
            return;
        }
        String content = Text.removeTags((String)message.getMessage());
        messageTriggers.forEach((pattern, method) -> {
            if (Pattern.compile(pattern).matcher(content).find()) {
                method.run();
            }
        });
    }

    private void checkAndUpdateSplasher(Actor target) {
        HashSet<Integer> splashAnimations = new HashSet<Integer>(Arrays.asList(708, 1162, 1167, 7855));
        if (this.client.getGameState() != GameState.LOGGED_IN || !(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        if (!splashAnimations.contains(player.getAnimation()) || player.getInteracting() == null || !this.session.isTarget(player.getInteracting())) {
            return;
        }
        if (this.session.getSplasher().getPlayer() != null && this.session.getSplasher().getPlayer().equals(player)) {
            this.session.getSplasher().updateLastAttack();
        } else {
            this.session.getSplasher().updatePlayer(player);
        }
    }

    private void checkAndMuteSoundEffect(SoundEffectPlayed soundEffect) {
        if (!this.session.isActive()) {
            return;
        }
        switch (soundEffect.getSoundId()) {
            case 509: 
            case 510: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 2727: {
                if (!this.config.muteFailSounds()) break;
                soundEffect.consume();
                break;
            }
            case 2581: {
                if (!this.config.muteSuccessSounds()) break;
                soundEffect.consume();
                break;
            }
            case 2115: {
                if (!this.config.muteEmptyPouchSound()) break;
                soundEffect.consume();
                break;
            }
            case 2277: {
                if (!this.config.muteNoSpaceSound()) break;
                soundEffect.consume();
                break;
            }
            case 5032: {
                if (!this.config.muteVeilActivateSound()) break;
                soundEffect.consume();
                break;
            }
            case 5062: {
                if (!this.config.muteVeilFadeSound()) break;
                soundEffect.consume();
            }
        }
    }

    private void checkAndUpdateTargetFromCache(NPC npc) {
        if (this.session.getTarget().getNpc() == null || npc.getName() == null) {
            return;
        }
        if (npc.getIndex() != this.session.getTarget().getNpc().getIndex()) {
            return;
        }
        this.session.getTarget().setNpc(npc);
    }

    private void checkAndUpdateTargetLocation() {
        if (this.session.getTarget().getNpc() == null) {
            return;
        }
        if (this.session.getTarget().getNpc().getWorldLocation().equals((Object)this.session.getTarget().getLastLocation())) {
            return;
        }
        this.session.getTarget().updateLocation(this.session.getTarget().getNpc().getWorldLocation());
    }

    private void swapLeftClickPickpocket() {
        if (!this.config.enableLeftClickPickpocket() || this.client.getGameState().getState() != GameState.LOGGED_IN.getState() || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] entries = this.client.getMenuEntries();
        HashMap<MenuEntry, Integer> swaps = new HashMap<MenuEntry, Integer>();
        HashMap<Integer, AbstractMap.SimpleEntry<MenuEntry, Integer>> defaultLeftClicks = new HashMap<Integer, AbstractMap.SimpleEntry<MenuEntry, Integer>>();
        for (int index2 = entries.length - 1; index2 >= 0; --index2) {
            MenuEntry entry2 = entries[index2];
            if (entry2.getNpc() == null) continue;
            if (entry2.getOption().equalsIgnoreCase("pickpocket")) {
                Map.Entry defaultLeftClickOption = (Map.Entry)defaultLeftClicks.get(entry2.getNpc().getIndex());
                if (defaultLeftClickOption == null) continue;
                swaps.put(entry2, (Integer)defaultLeftClickOption.getValue());
                swaps.put((MenuEntry)defaultLeftClickOption.getKey(), index2);
                continue;
            }
            if (entry2.getType() != MenuAction.NPC_FIRST_OPTION && entry2.getType() != MenuAction.NPC_SECOND_OPTION && entry2.getType() != MenuAction.NPC_THIRD_OPTION && entry2.getType() != MenuAction.NPC_FOURTH_OPTION || defaultLeftClicks.containsKey(entry2.getIdentifier())) continue;
            defaultLeftClicks.put(entry2.getNpc().getIndex(), new AbstractMap.SimpleEntry<MenuEntry, Integer>(entry2, index2));
        }
        if (swaps.isEmpty()) {
            return;
        }
        swaps.forEach((entry, index) -> {
            entries[index.intValue()] = entry;
        });
        try {
            this.client.setMenuEntries(entries);
        }
        catch (AssertionError er) {
            log.debug(((Throwable)((Object)er)).getMessage());
        }
    }
}

