/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper;

import com.pickpockethelper.PickpocketHelperConfig;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.NPC;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;

@Singleton
public class HighlightManager {
    private final PickpocketHelperConfig config;
    private final NpcOverlayService npcOverlayService;
    private final HashMap<NPC, HighlightedNpc> targets = new HashMap();

    @Inject
    public HighlightManager(PickpocketHelperConfig config, NpcOverlayService npcOverlayService, ClientThread clientThread) {
        this.config = config;
        this.npcOverlayService = npcOverlayService;
        npcOverlayService.registerHighlighter(this.targets::get);
        clientThread.invoke(this::refresh);
    }

    private HighlightedNpc highLightNpc(NPC npc) {
        return HighlightedNpc.builder().npc(npc).highlightColor(this.config.highlightColor()).fillColor(this.config.fillColor()).hull(this.config.highLightTarget()).borderWidth((float)this.config.borderWidth()).outlineFeather(this.config.outlineFeather()).build();
    }

    public void addTarget(NPC target) {
        this.targets.put(target, this.highLightNpc(target));
        this.refresh();
    }

    public void removeTarget(NPC target) {
        this.targets.remove(target);
        this.refresh();
    }

    public void replaceTarget(NPC oldTarget, NPC newTarget) {
        this.targets.remove(oldTarget);
        this.addTarget(newTarget);
    }

    public void clearTargets() {
        this.targets.clear();
        this.refresh();
    }

    public void refresh() {
        this.targets.keySet().forEach(npc -> this.targets.replace((NPC)npc, this.highLightNpc((NPC)npc)));
        this.npcOverlayService.rebuild();
    }
}

