/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper;

import com.pickpockethelper.PickpocketHelperConfig;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;

@Singleton
public class FeedbackManager {
    private final PickpocketHelperConfig config;
    private final Notifier notifier;
    private final ChatMessageManager chatMessageManager;

    @Inject
    public FeedbackManager(PickpocketHelperConfig config, Notifier notifier, ChatMessageManager chatMessageManager) {
        this.config = config;
        this.notifier = notifier;
        this.chatMessageManager = chatMessageManager;
    }

    public void sendChatMessage(String content, ChatColorType type) {
        String message = new ChatMessageBuilder().append(type).append(content).build();
        this.sendChatMessage(message);
    }

    public void sendChatMessage(String content) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(content).build());
    }

    public void sendNotification(String content, boolean sendChatMessage) {
        this.notifier.notify(content);
        if (sendChatMessage && !this.config.muteChatMessages()) {
            this.sendChatMessage(content, ChatColorType.HIGHLIGHT);
        }
    }
}

