/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AudioManager {
    private static final Logger log = LoggerFactory.getLogger(AudioManager.class);
    private final HashMap<Integer, Clip> clips = new HashMap();

    public boolean play(int alertId) {
        if (!this.clips.containsKey(alertId)) {
            log.debug("Clip doesn't exist: " + alertId);
            return false;
        }
        Clip clip = this.clips.get(alertId);
        if (clip.isRunning()) {
            return true;
        }
        clip.setFramePosition(0);
        clip.start();
        return true;
    }

    public void init() {
        HashMap<Integer, String> alertAudioFiles = new HashMap<Integer, String>();
        alertAudioFiles.put(4, "rogue_set.wav");
        alertAudioFiles.put(0, "dodgy_necklace_break.wav");
        alertAudioFiles.put(1, "hitpoints_low.wav");
        alertAudioFiles.put(5, "shadow_veil_faded.wav");
        alertAudioFiles.put(7, "target_despawn.wav");
        alertAudioFiles.put(6, "splasher_idle.wav");
        alertAudioFiles.put(3, "player_idle.wav");
        alertAudioFiles.put(2, "no_space.wav");
        alertAudioFiles.forEach(this::loadAudioFile);
    }

    public void clear() {
        this.clips.forEach((id, clip) -> {
            clip.stop();
            clip.flush();
            clip.close();
        });
        this.clips.clear();
    }

    private void loadAudioFile(int alertId, String fileName) {
        try (InputStream source = this.getClass().getResourceAsStream("/audio/" + fileName);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(source);
             AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);){
            Clip clip = AudioSystem.getClip();
            this.clips.put(alertId, clip);
            clip.open(audioInputStream);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }
}

