/*
 * Decompiled with CFR 0.152.
 */
package com.pickpockethelper;

import com.pickpockethelper.AudioManager;
import com.pickpockethelper.FeedbackManager;
import com.pickpockethelper.PickpocketHelperConfig;
import com.pickpockethelper.entity.Session;
import com.pickpockethelper.utility.AlertType;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.chat.ChatColorType;

@Singleton
public class AlertManager {
    @Inject
    private FeedbackManager feedbackManager;
    @Inject
    private AudioManager audioManager;
    @Inject
    private Session session;
    @Inject
    private PickpocketHelperConfig config;
    private static final Map<Integer, String> messages = new HashMap<Integer, String>();

    public AlertManager() {
        messages.put(0, "Your dodgy necklace broke!");
        messages.put(1, "Your hitpoints are low!");
        messages.put(5, "Shadow Veil has faded!");
        messages.put(7, "Your target is about to de-spawn!");
        messages.put(4, "You are not wearing the full rogue set!");
        messages.put(6, "Your target is no longer being splashed!");
        messages.put(3, "You are no longer pickpocketing!");
        messages.put(2, "There is no space for your loot!");
        messages.put(8, "Your gloves of silence are about to break!");
    }

    public void sendAlert(int alertId, boolean includeChatMessage) {
        if (!this.session.isActive()) {
            return;
        }
        AlertType type = this.config.getAlertType();
        if (type == AlertType.CHAT_MESSAGE || includeChatMessage) {
            this.feedbackManager.sendChatMessage(messages.get(alertId), ChatColorType.HIGHLIGHT);
        }
        boolean audioSuccess = true;
        if (type == AlertType.SPEECH) {
            audioSuccess = this.audioManager.play(alertId);
        }
        if (type == AlertType.NOTIFICATION || !audioSuccess) {
            this.feedbackManager.sendNotification(messages.get(alertId), false);
        }
    }
}

