/*
 * Decompiled with CFR 0.152.
 */
package com.smartchatinputcolor;

import com.smartchatinputcolor.ChatChannel;
import com.smartchatinputcolor.ChatPanel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.FriendsChatChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.vars.AccountType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Smart Chat Input Color")
public class SmartChatInputColorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SmartChatInputColorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    private ChatPanel selectedChatPanel = null;
    private boolean isInFriendsChat = false;
    private boolean hoppingWorlds = false;
    private boolean shouldInitialize = false;
    private final Map<ChatChannel, Color> channelColorMap = new HashMap<ChatChannel, Color>();

    protected void startUp() {
        log.debug("Smart Chat Input Color starting!");
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.shouldInitialize = true;
        }
    }

    protected void shutDown() {
        log.debug("Smart Chat Input Color stopping!");
        this.selectedChatPanel = null;
        this.isInFriendsChat = false;
        this.channelColorMap.clear();
    }

    private void recolorChatTypedText() {
        Widget inputWidget = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (inputWidget == null) {
            return;
        }
        String input = inputWidget.getText();
        if (input.endsWith("Press Enter to Chat...")) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        String name = input.contains(":") ? input.split(":")[0] : player.getName();
        String text = this.client.getVarcStrValue(335);
        inputWidget.setText(name + ": " + ColorUtil.wrapWithColorTag((String)(Text.escapeJagex((String)text) + "*"), (Color)this.channelColorMap.get((Object)this.deriveChatChannel(name, text))));
    }

    private ChatChannel deriveChatChannel(String name, String text) {
        if (ChatChannel.GUEST.matchesRegex(text)) {
            return ChatChannel.GUEST;
        }
        if (ChatChannel.GIM.matchesRegex(text)) {
            return this.getGIMChatChannel(text);
        }
        if (ChatChannel.CLAN.matchesRegex(text)) {
            return ChatChannel.CLAN;
        }
        if (ChatChannel.FRIEND.matchesRegex(text)) {
            return this.getFriendsChatChannel();
        }
        if (ChatChannel.PUBLIC.matchesRegex(text)) {
            return ChatChannel.PUBLIC;
        }
        if (name.contains("(")) {
            switch (name = name.split("\\(")[1].replace(")", "")) {
                case "channel": {
                    return this.getFriendsChatChannel();
                }
                case "clan": {
                    return ChatChannel.CLAN;
                }
                case "guest clan": {
                    return ChatChannel.GUEST;
                }
                case "group": {
                    return ChatChannel.GIM;
                }
            }
        }
        return this.getSelectedChatPanelChannel();
    }

    private Color computeChannelColor(ChatChannel channel) {
        Color color;
        boolean transparent = this.client.isResized() && this.client.getVarbitValue(4608) == 1;
        String colorConfigKey = channel.getColorConfigKey();
        if (colorConfigKey != null && (color = (Color)this.configManager.getConfiguration("textrecolor", (transparent ? "transparent" : "opaque") + colorConfigKey, Color.class)) != null) {
            return color;
        }
        int colorCode = this.client.getVarpValue(transparent ? channel.getTransparentVarpId() : channel.getOpaqueVarpId()) - 1;
        if (colorCode == 0) {
            return Color.BLACK;
        }
        if (colorCode == -1) {
            return new Color(transparent ? channel.getTransparentDefaultRgb() : channel.getOpaqueDefaultRgb());
        }
        return new Color(colorCode);
    }

    private void populateChatChannelColorMap() {
        for (ChatChannel channel : ChatChannel.values()) {
            this.channelColorMap.put(channel, this.computeChannelColor(channel));
        }
    }

    public ChatChannel getFriendsChatChannel() {
        return this.isInFriendsChat ? ChatChannel.FRIEND : ChatChannel.PUBLIC;
    }

    private ChatChannel getGIMChatChannel(String text) {
        if (this.client.getAccountType() == AccountType.GROUP_IRONMAN) {
            return ChatChannel.GIM;
        }
        if (text.startsWith("/g")) {
            return this.getFriendsChatChannel();
        }
        if (text.startsWith("/@g")) {
            return ChatChannel.CLAN;
        }
        if (text.startsWith("////")) {
            return ChatChannel.GUEST;
        }
        return ChatChannel.GIM;
    }

    private ChatChannel getSelectedChatPanelChannel() {
        switch (this.selectedChatPanel) {
            case CHANNEL: {
                return this.getFriendsChatChannel();
            }
            case CLAN: {
                return ChatChannel.CLAN;
            }
        }
        return ChatChannel.PUBLIC;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 223) {
            this.recolorChatTypedText();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case HOPPING: {
                this.hoppingWorlds = true;
                break;
            }
            case LOGGED_IN: {
                if (this.hoppingWorlds) {
                    this.hoppingWorlds = false;
                    return;
                }
                this.shouldInitialize = true;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick ignored) {
        if (this.shouldInitialize) {
            this.selectedChatPanel = ChatPanel.fromInt(this.client.getVarcIntValue(41));
            this.isInFriendsChat = this.client.getFriendsChatManager() != null;
            this.populateChatChannelColorMap();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("textrecolor")) {
            this.clientThread.invoke(() -> {
                this.populateChatChannelColorMap();
                this.recolorChatTypedText();
            });
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int varPlayerId = varbitChanged.getVarpId();
        for (ChatChannel channel : ChatChannel.values()) {
            if (varPlayerId != channel.getOpaqueVarpId() && varPlayerId != channel.getTransparentVarpId()) continue;
            this.populateChatChannelColorMap();
            return;
        }
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (varClientIntChanged.getIndex() == 41) {
            this.selectedChatPanel = ChatPanel.fromInt(this.client.getVarcIntValue(41));
        }
    }

    @Subscribe
    public void onFriendsChatChanged(FriendsChatChanged friendsChatChanged) {
        this.isInFriendsChat = friendsChatChanged.isJoined();
        this.recolorChatTypedText();
    }
}

