/*
 * Decompiled with CFR 0.152.
 */
package com.smartchatinputcolor;

import java.util.regex.Pattern;

enum ChatChannel {
    PUBLIC("PublicChat", 3000, 2992, 0x9090FF, 255, Pattern.compile("^/@?p.*")),
    FRIEND("ClanChatMessage", 3004, 2996, 15683664, 0x7F0000, Pattern.compile("^/(@?f)?.*")),
    CLAN("ClanMessage", 3005, 2997, 0x7F0000, 0x7F0000, Pattern.compile("^/(@?c|/).*")),
    GUEST("ClanGuestMessage", 3061, 3060, 0x7F0000, 0x7F0000, Pattern.compile("^/(@?gc|//).*")),
    GIM(null, 3194, 3191, 0x7F0000, 0x7F0000, Pattern.compile("^/(@?g|/{3}).*"));

    private final String colorConfigKey;
    private final int transparentVarpId;
    private final int opaqueVarpId;
    private final int transparentDefaultRgb;
    private final int opaqueDefaultRgb;
    private final Pattern regex;

    public boolean matchesRegex(String text) {
        return this.regex.matcher(text).matches();
    }

    private ChatChannel(String colorConfigKey, int transparentVarpId, int opaqueVarpId, int transparentDefaultRgb, int opaqueDefaultRgb, Pattern regex) {
        this.colorConfigKey = colorConfigKey;
        this.transparentVarpId = transparentVarpId;
        this.opaqueVarpId = opaqueVarpId;
        this.transparentDefaultRgb = transparentDefaultRgb;
        this.opaqueDefaultRgb = opaqueDefaultRgb;
        this.regex = regex;
    }

    public String getColorConfigKey() {
        return this.colorConfigKey;
    }

    public int getTransparentVarpId() {
        return this.transparentVarpId;
    }

    public int getOpaqueVarpId() {
        return this.opaqueVarpId;
    }

    public int getTransparentDefaultRgb() {
        return this.transparentDefaultRgb;
    }

    public int getOpaqueDefaultRgb() {
        return this.opaqueDefaultRgb;
    }
}

