/*
 * Decompiled with CFR 0.152.
 */
package com.exchangelogger;

import com.exchangelogger.ExchangeLoggerFormat;
import com.exchangelogger.ExchangeLoggerFormatting;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Scanner;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.events.GrandExchangeOfferChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeLoggerWriter {
    private static final Logger log = LoggerFactory.getLogger(ExchangeLoggerWriter.class);
    private File logFile;
    private boolean fileExist = true;
    private final int[] prevQuantity;
    private final GrandExchangeOfferState[] prevState;
    private final ExchangeLoggerFormatting formatting;
    private ExchangeLoggerFormat format;
    private boolean rewrite;
    private final String logPath;
    private String logDate = this.currentDateTime("yyyy-MM-dd");

    ExchangeLoggerWriter(String path, ExchangeLoggerFormat form, boolean re) {
        this.logPath = path;
        this.format = form;
        this.rewrite = re;
        this.prevQuantity = new int[8];
        this.prevState = new GrandExchangeOfferState[8];
        Arrays.fill(this.prevQuantity, -1);
        this.formatting = new ExchangeLoggerFormatting();
        this.logFile = new File(this.logPath);
        if (this.logFile.isFile()) {
            if (this.rewrite) {
                this.removeCurrentFile();
                this.logFile = this.createLog(this.logPath);
            } else {
                this.fileDateCheck();
            }
        } else {
            this.logFile = this.createLog(this.logPath);
        }
    }

    public void grandExchangeEvent(GrandExchangeOfferChanged event) {
        int slot;
        GrandExchangeOffer offer;
        String time = this.currentDateTime("yyyy-MM-dd HH:mm:ss");
        if (!this.fileExist) {
            return;
        }
        if (!this.rewrite && !this.logDate.equals(time.substring(0, this.logDate.length()))) {
            this.preserveCurrentFile(this.logDate);
        }
        if (this.duplicateHandler(offer = event.getOffer(), slot = event.getSlot())) {
            return;
        }
        this.writeFile(offer, slot, time);
    }

    private void writeFile(GrandExchangeOffer offer, int slot, String time) {
        String writeLine = "";
        try {
            FileWriter writer = new FileWriter(this.logFile, true);
            switch (this.format) {
                case TEXT: {
                    writeLine = this.formatting.plainText(offer, slot, time);
                    break;
                }
                case TABULAR: {
                    writeLine = this.formatting.tabular(offer, slot, time);
                    break;
                }
                case JSON: {
                    writeLine = this.formatting.json(offer, slot, time);
                }
            }
            writer.write(writeLine + "\n");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            log.warn("An error occurred while writing to log file: " + e.toString());
        }
    }

    private boolean duplicateHandler(GrandExchangeOffer offer, int slot) {
        boolean duplicate = false;
        if (this.prevQuantity[slot] == offer.getQuantitySold() && this.formatting.anyEqualState(offer.getState(), GrandExchangeOfferState.BUYING, GrandExchangeOfferState.SELLING) || this.prevState[slot] == offer.getState() && this.formatting.anyEqualState(offer.getState(), GrandExchangeOfferState.CANCELLED_BUY, GrandExchangeOfferState.CANCELLED_SELL)) {
            duplicate = true;
        } else {
            this.prevQuantity[slot] = offer.getState() == GrandExchangeOfferState.EMPTY ? -1 : offer.getQuantitySold();
            this.prevState[slot] = offer.getState();
        }
        return duplicate;
    }

    private String currentDateTime(String form) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(form);
        return formatter.format(date);
    }

    private void preserveCurrentFile(String fileDate) {
        String fileType = ".log";
        Object rename = this.logPath.substring(0, this.logPath.length() - fileType.length());
        if (!this.logFile.renameTo(new File((String)(rename = (String)rename + "_" + fileDate + fileType)))) {
            log.debug("Failed to rename previous file to: " + (String)rename);
        }
        this.logFile = this.createLog(this.logPath);
    }

    private void fileDateCheck() {
        String fileDate = "";
        try {
            Scanner reader = new Scanner(this.logFile);
            if (reader.hasNextLine()) {
                fileDate = reader.nextLine();
                if (fileDate.contains("{")) {
                    String remove = "{\"date\":\"";
                    fileDate = fileDate.substring(remove.length(), this.logDate.length() + remove.length());
                } else {
                    fileDate = fileDate.substring(0, this.logDate.length());
                }
            }
            reader.close();
        }
        catch (IOException e) {
            log.warn("Couldn't read file: " + this.logFile.toString() + " " + e.toString());
        }
        if (!fileDate.equals(this.logDate) && !fileDate.equals("")) {
            this.preserveCurrentFile(fileDate);
        }
    }

    private File createLog(String path) {
        this.logDate = this.currentDateTime("yyyy-MM-dd");
        try {
            File log = new File(path);
            if (log.createNewFile()) {
                this.fileExist = true;
                return log;
            }
        }
        catch (IOException e) {
            log.warn("An error occurred while creating a new log file" + e.toString());
        }
        this.fileExist = false;
        return null;
    }

    public void removeCurrentFile() {
        try {
            if (!this.logFile.delete()) {
                log.debug("Failed to delete old log file: " + this.logFile.toString());
            }
        }
        catch (Exception e) {
            log.warn("Error deleting old log file: " + e.toString());
        }
    }

    public void setRewrite(boolean re) {
        this.rewrite = re;
    }

    public void setFormat(ExchangeLoggerFormat form) {
        this.format = form;
    }
}

