/*
 * Decompiled with CFR 0.152.
 */
package com.exchangelogger;

import com.exchangelogger.ExchangeLoggerConfig;
import com.exchangelogger.ExchangeLoggerFormat;
import com.exchangelogger.ExchangeLoggerWriter;
import com.google.inject.Provides;
import java.io.File;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Exchange Logger", description="Stores all GE transactions in log file(s)")
public class ExchangeLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ExchangeLoggerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ExchangeLoggerConfig config;
    private final String dirName = File.separator + "exchange-logger";
    private final String logName = File.separator + "exchange.log";
    public static final String CONFIG_GROUP = "exchangelogger";
    private ExchangeLoggerFormat format;
    private boolean rewrite;
    public String logPath;
    private ExchangeLoggerWriter writer;

    protected void startUp() throws Exception {
        this.format = this.config.logFormat();
        this.rewrite = this.config.rewriteLog();
        String dir = RuneLite.RUNELITE_DIR.getPath() + this.dirName;
        new File(dir).mkdirs();
        this.logPath = dir + this.logName;
        this.writer = new ExchangeLoggerWriter(this.logPath, this.format, this.rewrite);
    }

    protected void shutDown() throws Exception {
        log.info("ExchangeLogger stopped!");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            if (event.getKey().equals("logFormat")) {
                this.format = this.config.logFormat();
                this.writer.setFormat(this.format);
            } else if (event.getKey().equals("rewriteLog")) {
                this.rewrite = this.config.rewriteLog();
                this.writer.setRewrite(this.rewrite);
            }
        }
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerEvent) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.writer.grandExchangeEvent(offerEvent);
        }
    }

    @Provides
    ExchangeLoggerConfig provideConfig(ConfigManager configManager) {
        return (ExchangeLoggerConfig)configManager.getConfig(ExchangeLoggerConfig.class);
    }
}

