/*
 * Decompiled with CFR 0.152.
 */
package com.exchangelogger;

import com.exchangelogger.ExchangeLoggerSlotStatus;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;

public class ExchangeLoggerFormatting {
    String line;

    public String plainText(GrandExchangeOffer offer, int slot, String time) {
        if (offer.getQuantitySold() == 0 && this.anyEqualState(offer.getState(), GrandExchangeOfferState.BUYING, GrandExchangeOfferState.SELLING)) {
            String firstState = offer.getState() == GrandExchangeOfferState.BUYING ? "BUY" : "SELL";
            this.line = time + " state: " + firstState + " slot: " + slot + " item: " + offer.getItemId() + " max: " + offer.getTotalQuantity() + " offer: " + offer.getPrice();
        } else {
            this.line = this.anyEqualState(offer.getState(), GrandExchangeOfferState.CANCELLED_BUY, GrandExchangeOfferState.CANCELLED_SELL) ? time + " state: " + offer.getState() + " slot: " + slot + " item: " + offer.getItemId() + " qty: " + offer.getQuantitySold() + " worth: " + offer.getSpent() + " max: " + offer.getTotalQuantity() : (offer.getState() == GrandExchangeOfferState.EMPTY ? time + " state: " + offer.getState() + " slot: " + slot : time + " state: " + offer.getState() + " slot: " + slot + " item: " + offer.getItemId() + " qty: " + offer.getQuantitySold() + " worth: " + offer.getSpent());
        }
        return this.line;
    }

    public String tabular(GrandExchangeOffer offer, int slot, String time) {
        String[] split = time.split(" ", 2);
        this.line = split[0] + "," + split[1] + "," + offer.getState() + "," + slot + "," + offer.getItemId() + "," + offer.getQuantitySold() + "," + offer.getSpent() + "," + offer.getTotalQuantity() + "," + offer.getPrice();
        return this.line;
    }

    public String json(GrandExchangeOffer offer, int slot, String time) {
        ExchangeLoggerSlotStatus status = new ExchangeLoggerSlotStatus();
        String[] split = time.split(" ", 2);
        status.date = split[0];
        status.time = split[1];
        status.state = offer.getState();
        status.slot = slot;
        status.item = offer.getItemId();
        status.qty = offer.getQuantitySold();
        status.worth = offer.getSpent();
        status.max = offer.getTotalQuantity();
        status.offer = offer.getPrice();
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        String jsonString = gson.toJson((Object)status);
        return jsonString;
    }

    public boolean anyEqualState(GrandExchangeOfferState expected, GrandExchangeOfferState ... array) {
        for (GrandExchangeOfferState state : array) {
            if (!state.equals((Object)expected)) continue;
            return true;
        }
        return false;
    }
}

