/*
 * Decompiled with CFR 0.152.
 */
package com.birdhouseOverlay;

import com.birdhouseOverlay.BirdhouseColoringOverlay;
import com.birdhouseOverlay.BirdhouseOverlayConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Birdhouse Overlay")
public class BirdhouseOverlayPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BirdhouseOverlayPlugin.class);
    private static final int MEADOW_NORTH = 30565;
    private static final int MEADOW_SOUTH = 30566;
    private static final int VALLEY_NORTH = 30567;
    private static final int VALLEY_SOUTH = 30568;
    @Inject
    private Client client;
    @Inject
    private BirdhouseOverlayConfig config;
    @Inject
    private BirdhouseColoringOverlay overlay;
    private GameObject meadowNorth;
    private GameObject meadowSouth;
    private GameObject valleyNorth;
    private GameObject valleySouth;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.meadowNorth = null;
        this.meadowSouth = null;
        this.valleyNorth = null;
        this.valleySouth = null;
    }

    @Provides
    BirdhouseOverlayConfig provideConfig(ConfigManager configManager) {
        return (BirdhouseOverlayConfig)configManager.getConfig(BirdhouseOverlayConfig.class);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 30565: {
                this.meadowNorth = gameObject;
                break;
            }
            case 30566: {
                this.meadowSouth = gameObject;
                break;
            }
            case 30567: {
                this.valleyNorth = gameObject;
                break;
            }
            case 30568: {
                this.valleySouth = gameObject;
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 30565: {
                this.meadowNorth = null;
                break;
            }
            case 30566: {
                this.meadowSouth = null;
                break;
            }
            case 30567: {
                this.valleyNorth = null;
                break;
            }
            case 30568: {
                this.valleySouth = null;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.meadowNorth = null;
            this.meadowSouth = null;
            this.valleyNorth = null;
            this.valleySouth = null;
        }
    }

    GameObject getMeadowNorth() {
        return this.meadowNorth;
    }

    GameObject getMeadowSouth() {
        return this.meadowSouth;
    }

    GameObject getValleyNorth() {
        return this.valleyNorth;
    }

    GameObject getValleySouth() {
        return this.valleySouth;
    }
}

