/*
 * Decompiled with CFR 0.152.
 */
package com.birdhouseOverlay;

import com.birdhouseOverlay.BirdhouseOverlayConfig;
import com.birdhouseOverlay.BirdhouseOverlayPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BirdhouseColoringOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(BirdhouseColoringOverlay.class);
    private final Client client;
    private final BirdhouseOverlayConfig config;
    private final BirdhouseOverlayPlugin plugin;
    private static final int MAX_DISTANCE = 2350;

    @Inject
    private BirdhouseColoringOverlay(Client client, BirdhouseOverlayPlugin plugin, BirdhouseOverlayConfig config, ModelOutlineRenderer modelOutlineRenderer) {
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        GameObject meadowNorth = this.plugin.getMeadowNorth();
        GameObject meadowSouth = this.plugin.getMeadowSouth();
        GameObject valleyNorth = this.plugin.getValleyNorth();
        GameObject valleySouth = this.plugin.getValleySouth();
        if (!Objects.isNull(meadowNorth)) {
            int meadowNorthState = this.client.getVarpValue(1626);
            this.birdhouseStateRenderer(meadowNorth, meadowNorthState, graphics);
        }
        if (!Objects.isNull(meadowSouth)) {
            int meadowSouthState = this.client.getVarpValue(1627);
            this.birdhouseStateRenderer(meadowSouth, meadowSouthState, graphics);
        }
        if (!Objects.isNull(valleyNorth)) {
            int valleyNorthState = this.client.getVarpValue(1628);
            this.birdhouseStateRenderer(valleyNorth, valleyNorthState, graphics);
        }
        if (!Objects.isNull(valleySouth)) {
            int valleySouthState = this.client.getVarpValue(1629);
            this.birdhouseStateRenderer(valleySouth, valleySouthState, graphics);
        }
        return null;
    }

    private void birdhouseStateRenderer(GameObject birdhouse, int state, Graphics2D graphics) {
        Color unbuiltColor = this.config.getUnbuiltColor();
        Color unseededColor = this.config.getUnseededColor();
        Color seededColor = this.config.getSeededColor();
        if (state == 0) {
            this.renderObject(birdhouse, graphics, unbuiltColor);
            log.debug(birdhouse + "rendered RED");
        } else if (state % 3 == 0) {
            this.renderObject(birdhouse, graphics, seededColor);
            log.debug(birdhouse + "rendered GREEN");
        } else {
            this.renderObject(birdhouse, graphics, unseededColor);
            log.debug(birdhouse + "rendered YELLOW");
        }
    }

    private void renderObject(GameObject object, Graphics2D graphics, Color color) {
        Shape objectClickbox;
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        if (Objects.isNull(localLocation)) {
            return;
        }
        Point mousePosition = this.client.getMouseCanvasPosition();
        LocalPoint location = object.getLocalLocation();
        if (localLocation.distanceTo(location) <= 2350 && (objectClickbox = object.getClickbox()) != null) {
            if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(color.darker());
                log.debug("Setting Clickbox - Darker");
            } else {
                graphics.setColor(color);
                log.debug("Setting Clickbox - Normal");
            }
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(objectClickbox);
        }
    }
}

