/*
 * Decompiled with CFR 0.152.
 */
package com.github.MitzDK;

import com.github.MitzDK.DropSoundsConfig;
import com.github.MitzDK.Sound;
import com.github.MitzDK.SoundEngine;
import com.github.MitzDK.SoundFileManager;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Drop Sounds", description="Turn on Loot drop notifications / Untradeable in Runescape settings", tags={"announce", "sound"})
public class DropSoundsCompletedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DropSoundsCompletedPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private DropSoundsConfig config;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    private final Map<Skill, Integer> oldExperience = new EnumMap<Skill, Integer>(Skill.class);
    private final Map<Integer, Integer> oldAchievementDiaries = new HashMap<Integer, Integer>();
    private int lastLoginTick = -1;
    private int lastGEOfferTick = -1;
    private int lastZulrahKillTick = -1;
    static final Pattern regexPattern = Pattern.compile("\\w+(?=\\s+coin)");

    protected void startUp() throws Exception {
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
        });
    }

    protected void shutDown() throws Exception {
        this.oldExperience.clear();
        this.oldAchievementDiaries.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN_AUTHENTICATOR: {
                this.oldExperience.clear();
                this.oldAchievementDiaries.clear();
            }
            case CONNECTION_LOST: {
                this.lastLoginTick = -1;
                break;
            }
            case LOGGED_IN: {
                this.lastLoginTick = this.client.getTickCount();
            }
        }
    }

    List<String> getHighlights() {
        String configItems = this.config.itemsToNotify();
        if (configItems.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configItems);
    }

    private static String findCoinValue(String originalStr) {
        Matcher matcher = regexPattern.matcher(originalStr = originalStr.replaceAll(",", ""));
        if (matcher.find()) {
            String stringToReturn = matcher.group(0);
            return stringToReturn;
        }
        return null;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        Integer coinValue;
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.CLAN_GIM_MESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE && chatMessage.getMessage().contains("Valuable drop: ") && (coinValue = Integer.valueOf(Integer.parseInt(DropSoundsCompletedPlugin.findCoinValue(chatMessage.getMessage())))) >= this.config.valueThreshold()) {
            this.soundEngine.playClip(Sound.VALUABLE_DROP);
        }
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE && chatMessage.getMessage().contains("Untradeable drop: ")) {
            for (String str : this.getHighlights()) {
                if (!chatMessage.getMessage().split(": ")[1].contains(str)) continue;
                this.soundEngine.playClip(Sound.UNTRADEABLE_DROP);
            }
        }
    }

    @Provides
    DropSoundsConfig provideConfig(ConfigManager configManager) {
        return (DropSoundsConfig)configManager.getConfig(DropSoundsConfig.class);
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }
}

