/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.Profiler;
import java.io.IOException;
import java.io.OutputStream;

public class ZstdOutputStream
extends OutputStream {
    private static final int ZSTD_E_CONTINUE = 0;
    private static final int ZSTD_E_FLUSH = 1;
    private static final int ZSTD_E_END = 2;
    private final OutputStream out;
    private final byte[] outBuf;
    private final byte[] inBuf;
    private int inBufPtr;
    private long stream;

    public static void init() {
        Profiler.init();
    }

    public ZstdOutputStream(OutputStream out, int level) {
        this.out = out;
        this.outBuf = new byte[ZstdOutputStream.cStreamOutSize()];
        this.inBuf = new byte[ZstdOutputStream.cStreamInSize()];
        this.stream = ZstdOutputStream.new0(level);
        if (this.stream == 0L) {
            throw new RuntimeException();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.inBufPtr + 1 >= this.inBuf.length) {
            this.flushBuffer(0);
        }
        this.inBuf[this.inBufPtr++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= 32) {
            this.flushBuffer(0);
            this.compress(b, off, len, 0);
        } else {
            int size = Math.min(len, this.inBuf.length - this.inBufPtr);
            System.arraycopy(b, off, this.inBuf, this.inBufPtr, size);
            this.inBufPtr += size;
            if (size != len) {
                System.arraycopy(b, off += size, this.inBuf, this.inBufPtr, len -= size);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(1);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer(2);
        this.free();
        this.out.close();
    }

    public void free() {
        ZstdOutputStream.free0(this.stream);
        this.stream = 0L;
    }

    private void flushBuffer(int endOp) throws IOException {
        this.compress(this.inBuf, 0, this.inBufPtr, endOp);
        this.inBufPtr = 0;
    }

    private void compress(byte[] buf, int off, int len, int endOp) throws IOException {
        boolean more;
        do {
            long res = ZstdOutputStream.compress0(this.stream, buf, off, len, this.outBuf, endOp);
            int wr = (int)(res >> 32);
            off += wr;
            len -= wr;
            int outLen = (int)res & Integer.MAX_VALUE;
            if (outLen > 0) {
                this.out.write(this.outBuf, 0, outLen);
            }
            boolean bl = more = (res >> 31 & 1L) != 0L;
        } while (len > 0 || endOp != 0 && more);
    }

    private static native int cStreamInSize();

    private static native int cStreamOutSize();

    private static native long new0(int var0);

    private static native void free0(long var0);

    private static native long compress0(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6) throws IOException;
}

