/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import com.google.common.base.Strings;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.awt.LayoutManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;
import net.runelite.client.RuneLite;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualMemoryPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(VirtualMemoryPanel.class);

    VirtualMemoryPanel() {
        if (OSType.getOSType() != OSType.Windows) {
            return;
        }
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JButton vmem = new JButton("Virtual Memory");
        vmem.addActionListener(_ev -> {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Save page table");
            fc.setSelectedFile(new File(FileSystemView.getFileSystemView().getDefaultDirectory(), "vmem.txt"));
            if (fc.showSaveDialog(this) != 0) {
                return;
            }
            this.recordVirtualMemory(fc.getSelectedFile());
        });
        JCheckBox onOOM = new JCheckBox("Record VMem on OOM");
        onOOM.addItemListener(ev -> {
            if (onOOM.isSelected()) {
                onOOM.setEnabled(false);
                Thread.UncaughtExceptionHandler rl = Thread.getDefaultUncaughtExceptionHandler();
                Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
                    if (throwable instanceof OutOfMemoryError) {
                        this.recordVirtualMemory(new File(RuneLite.LOGS_DIR, "vmem.txt"));
                    }
                    rl.uncaughtException(thread, throwable);
                });
            }
        });
        this.add(onOOM);
        this.add(vmem);
    }

    private void recordVirtualMemory(File file) {
        K32 k32 = (K32)Native.load((String)"kernel32", K32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            WinNT.MEMORY_BASIC_INFORMATION info = new WinNT.MEMORY_BASIC_INFORMATION();
            Pointer offset = Pointer.createConstant((int)0);
            while (true) {
                long size;
                if ((size = k32.VirtualQuery(offset, info, new BaseTSD.SIZE_T((long)info.size())).longValue()) <= 0L) {
                    writer.append("err=").append("" + Native.getLastError()).append('\n');
                    break;
                }
                long skip = Pointer.nativeValue((Pointer)info.baseAddress) - Pointer.nativeValue((Pointer)offset);
                if (skip > 0L) {
                    writer.append(VirtualMemoryPanel.hex(skip)).append(" free\n");
                }
                long end = Pointer.nativeValue((Pointer)info.baseAddress) + info.regionSize.longValue();
                writer.append(VirtualMemoryPanel.hex(Pointer.nativeValue((Pointer)info.baseAddress))).append('-').append(VirtualMemoryPanel.hex(end)).append(' ').append(VirtualMemoryPanel.hex(info.regionSize.longValue())).append(' ').append(Pointer.nativeValue((Pointer)info.allocationBase) == Pointer.nativeValue((Pointer)info.baseAddress) ? (char)'s' : ' ').append(" | ").append((info.protect.intValue() & 0x10) != 0 ? "x " : "  ").append((info.protect.intValue() & 0x20) != 0 ? "rx " : "   ").append((info.protect.intValue() & 0x40) != 0 ? "rwx " : "    ").append((info.protect.intValue() & 0x80) != 0 ? "rcx " : "    ").append((info.protect.intValue() & 1) != 0 ? "F " : "  ").append((info.protect.intValue() & 2) != 0 ? "r " : "  ").append((info.protect.intValue() & 4) != 0 ? "rw " : "   ").append((info.protect.intValue() & 8) != 0 ? "rc " : "   ").append((info.protect.intValue() & 0x100) != 0 ? (char)'g' : ' ').append((info.protect.intValue() & 0x200) != 0 ? (char)'P' : ' ').append(" | ").append((info.state.intValue() & 0x1000) != 0 ? (char)'c' : ' ').append((info.state.intValue() & 0x10000) != 0 ? (char)'f' : ' ').append((info.state.intValue() & 0x2000) != 0 ? (char)'r' : ' ').append(" | ").append((info.type.intValue() & 0x1000000) != 0 ? (char)'i' : ' ').append((info.type.intValue() & 0x40000) != 0 ? (char)'m' : ' ').append((info.type.intValue() & 0x20000) != 0 ? (char)'p' : ' ').append(" protect=").append(Integer.toHexString(info.protect.intValue())).append(" allocProtect=").append(Integer.toHexString(info.allocationProtect.intValue())).append('\n');
                if (end < Pointer.nativeValue((Pointer)offset)) {
                    break;
                }
                Pointer.nativeValue((Pointer)offset, (long)end);
            }
        }
        catch (IOException e) {
            log.warn("unable to write page table", (Throwable)e);
        }
    }

    private static String hex(long value) {
        return "0x" + Strings.padStart((String)Long.toHexString(value), (int)(Native.POINTER_SIZE * 2), (char)'0');
    }

    public static interface K32
    extends StdCallLibrary {
        public BaseTSD.SIZE_T VirtualQuery(Pointer var1, WinNT.MEMORY_BASIC_INFORMATION var2, BaseTSD.SIZE_T var3);
    }
}

