/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.runelite.client.RuneLiteProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMConfigPatch {
    private static final Logger log = LoggerFactory.getLogger(VMConfigPatch.class);
    @Nullable
    private static final String unsupported = VMConfigPatch.unsupported();
    @Nullable
    private static File packrConfigFile;
    private final Gson gson;
    private final String name;
    private final String[] args;

    private static String unsupported() {
        String launcherVer = RuneLiteProperties.getLauncherVersion();
        if (launcherVer == null) {
            return "Not using launcher";
        }
        if (!launcherVer.startsWith("2")) {
            return "Launcher out of date";
        }
        ProcessHandle.Info proc = ProcessHandle.current().info();
        String cmdline = proc.command().get().toLowerCase(Locale.ROOT);
        if (!cmdline.endsWith("runelite.exe")) {
            return "Not using EXE launcher";
        }
        packrConfigFile = new File(new File(cmdline).getParentFile().getAbsoluteFile(), "config.json");
        if (!packrConfigFile.exists()) {
            return "Cannot find config";
        }
        return null;
    }

    public static boolean isSupported() {
        return unsupported == null;
    }

    public VMConfigPatch(Gson gson, String name, String ... args) {
        this.gson = gson.newBuilder().setPrettyPrinting().create();
        this.name = name;
        this.args = args;
    }

    public String status() {
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (Arrays.stream(this.args).allMatch(args::contains)) {
            return this.name + " enabled";
        }
        if (unsupported != null) {
            return unsupported;
        }
        return this.name + " disabled" + (this.isInConfig() ? " (Restart to enable)" : "");
    }

    public boolean isInConfig() {
        JsonObject config = this.loadConfig();
        return config != null && Arrays.stream(this.args).allMatch(v -> config.get("vmArgs").getAsJsonArray().contains((JsonElement)new JsonPrimitive(v)));
    }

    private JsonObject loadConfig() {
        JsonObject jsonObject;
        FileInputStream fin = new FileInputStream(packrConfigFile);
        try {
            jsonObject = (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(fin), JsonObject.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                log.warn("error deserializing packr vm args!", e);
                return null;
            }
        }
        fin.close();
        return jsonObject;
    }

    public boolean set(boolean enabled) {
        JsonObject config = this.loadConfig();
        if (config == null) {
            return false;
        }
        JsonArray vmArgs = config.get("vmArgs").getAsJsonArray();
        this.setHasArg(vmArgs, "-Drunelite.launcher.reflect=true", enabled);
        for (String arg : this.args) {
            this.setHasArg(vmArgs, arg, enabled);
        }
        try {
            File tmpFile = File.createTempFile("runelite", null);
            try (FileOutputStream fout = new FileOutputStream(tmpFile);
                 FileChannel channel = fout.getChannel();
                 PrintWriter writer = new PrintWriter(fout);){
                channel.lock();
                writer.write(this.gson.toJson((JsonElement)config));
                channel.force(true);
            }
            try {
                Files.move(tmpFile.toPath(), packrConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ex) {
                log.debug("atomic move not supported", (Throwable)ex);
                Files.move(tmpFile.toPath(), packrConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            log.info("patched packr vm args");
        }
        catch (IOException e) {
            log.warn("error updating packr vm args!", (Throwable)e);
        }
        return true;
    }

    private void setHasArg(JsonArray args, String argStr, boolean enabled) {
        String prefix = null;
        int index = argStr.indexOf("=");
        if (index > 0) {
            prefix = argStr.substring(0, index + 1);
        }
        Iterator it = args.iterator();
        while (it.hasNext()) {
            JsonElement val = (JsonElement)it.next();
            if (!(prefix != null && enabled ? val.getAsString().startsWith(prefix) : val.getAsString().endsWith(argStr))) continue;
            it.remove();
        }
        if (enabled) {
            args.add((JsonElement)new JsonPrimitive(argStr));
        }
    }
}

