/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class SeekFile
extends DataInputStream {
    private final Input input;

    public SeekFile(File file) throws IOException {
        this(new Input(file));
    }

    private SeekFile(Input input) {
        super(input);
        this.input = input;
    }

    public void seek(long to) {
        this.input.ptr = to;
    }

    public long offset() {
        return this.input.ptr;
    }

    public void copyTo(OutputStream out, long bytes) throws IOException {
        this.input.copyTo(out, bytes);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public long readU4() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long length() {
        return this.input.end;
    }

    private static class Input
    extends InputStream {
        private static final int PAGE_MASK = 4095;
        private final RandomAccessFile raf;
        private long rafPtr;
        private long end;
        private final byte[] page = new byte[4096];
        private long pagePtr = -1L;
        private long ptr = 0L;

        Input(File file) throws IOException {
            this.raf = new RandomAccessFile(file, "r");
            this.end = this.raf.length();
        }

        @Override
        public int read() throws IOException {
            this.buffer();
            if (this.ptr >= this.end) {
                return -1;
            }
            return this.page[(int)this.ptr++ & 0xFFF] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.ptr >= this.end) {
                return -1;
            }
            if (this.bufAvailable() < 0 && len >= 4095) {
                int read;
                if (this.rafPtr != this.ptr) {
                    this.raf.seek(this.ptr);
                    this.rafPtr = this.ptr;
                }
                if ((read = this.raf.read(b, off, len / this.page.length * this.page.length)) > 0) {
                    this.rafPtr += (long)read;
                }
                return read;
            }
            this.buffer();
            int read = Math.min(len, this.bufAvailable());
            System.arraycopy(this.page, (int)this.ptr & 0xFFF, b, off, read);
            this.ptr += (long)read;
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            long start = this.ptr;
            this.ptr = Math.min(this.ptr + n, this.end);
            return this.ptr - start;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min(Integer.MAX_VALUE, this.end - this.ptr);
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            return this.copyTo(out, this.end - this.ptr);
        }

        public long copyTo(OutputStream out, long bytes) throws IOException {
            long start = this.ptr;
            long end = Math.min(this.end, this.ptr + bytes);
            while (this.ptr < end) {
                this.buffer();
                int read = Math.min((int)(end - this.ptr), this.bufAvailable());
                out.write(this.page, (int)this.ptr & 0xFFF, read);
                this.ptr += (long)read;
            }
            return this.ptr - start;
        }

        private void buffer() throws IOException {
            if (this.pagePtr == (this.ptr & 0xFFFFFFFFFFFFF000L)) {
                return;
            }
            this.pagePtr = this.ptr & 0xFFFFFFFFFFFFF000L;
            if (this.rafPtr != this.pagePtr) {
                this.raf.seek(this.pagePtr);
                this.rafPtr = this.pagePtr;
            }
            int fill = 0;
            while (fill < this.page.length && this.rafPtr < this.end) {
                int read = this.raf.read(this.page, fill, this.page.length - fill);
                if (read < 0) {
                    throw new EOFException();
                }
                fill += read;
                this.rafPtr += (long)read;
            }
        }

        private int bufAvailable() {
            long bufEnd = Math.min(this.pagePtr + (long)this.page.length, this.end);
            return (int)(bufEnd - this.ptr);
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

