/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.Profiler;
import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.filechooser.FileSystemView;
import net.runelite.api.Client;
import net.runelite.client.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfilerPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ProfilerPanel.class);
    private static final String KEY_SETUP = "setup";
    private static final String KEY_RUNNING = "running";
    private static final String KEY_STOPPED = "stopped";
    private static final String KEY_FAILURE = "failure";
    private final Client client;
    private final Gson gson;
    private final EventBus eventBus;
    private final SetupPanel setupPanel;
    private final RunningPanel runningPanel;
    private final StoppedPanel stoppedPanel;
    private final FailurePanel failurePanel;
    private final CardLayout layout;
    private final Map<String, Object> extra;
    private final List<EventEvent<?>> eventEvents;
    private Thread executorThread;
    private byte[] data;

    /*
     * Exception decompiling
     */
    @Inject
    public ProfilerPanel(Client client, ScheduledExecutorService executor, Gson gson, EventBus eventBus, @Named(value="runelite.version") String runeliteVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void show(String key) {
        this.layout.show(this, key);
        this.revalidate();
    }

    public void startProfiling() {
        log.info("Starting profiling");
        Thread[] threads = (Thread[])Stream.concat(Stream.of(this.client.getClientThread(), Thread.currentThread(), this.executorThread), Thread.getAllStackTraces().entrySet().stream().filter(e -> {
            String name = ((Thread)e.getKey()).getName();
            return "AWT-Windows".equals(name) || "AWT-XAWT".equals(name);
        }).map(e -> (Thread)e.getKey())).filter(Objects::nonNull).toArray(Thread[]::new);
        int delay = (Integer)this.setupPanel.sampleDelay.getValue();
        this.extra.put("delay", delay);
        try {
            Profiler.start(threads, (Integer)this.setupPanel.sampleBufferSize.getValue() * 1024, delay);
        }
        catch (Exception | LinkageError e2) {
            this.show(KEY_FAILURE);
            log.info("error starting profiler", e2);
            return;
        }
        for (EventEvent<?> ev : this.eventEvents) {
            ev.register(this.eventBus);
        }
        this.show(KEY_RUNNING);
        Timer timer = new Timer(100, null);
        timer.addActionListener(evAction -> {
            Profiler.Status status = Profiler.status();
            switch (status) {
                case RUNNING: {
                    this.runningPanel.buffer.setValue(Profiler.bufferOffset());
                    this.runningPanel.buffer.setMaximum(Profiler.bufferSize());
                    break;
                }
                case FAILED: {
                    this.stopProfiling();
                }
                case STOPPED: 
                case NOT_RUNNING: {
                    this.show(KEY_STOPPED);
                    timer.stop();
                    for (EventEvent<?> ev : this.eventEvents) {
                        ev.unregister(this.eventBus);
                    }
                    break;
                }
            }
        });
        timer.start();
    }

    public void stopProfiling() {
        String extraString = this.gson.toJson(this.extra);
        this.data = Profiler.stop(extraString.getBytes(StandardCharsets.UTF_8));
        this.show(KEY_STOPPED);
        this.stoppedPanel.status.setText("");
    }

    private /* synthetic */ void lambda$new$1() {
        this.executorThread = Thread.currentThread();
    }

    private static class EventEvent<T> {
        private final int id;
        private final Class<T> clazz;
        private final Function<T, int[]> consumer;
        private EventBus.Subscriber subscriber = null;

        EventEvent(int id, Class<T> clazz) {
            this(id, clazz, null);
        }

        void register(EventBus eventBus) {
            assert (this.subscriber == null);
            this.subscriber = eventBus.register(this.clazz, ev -> {
                int[] data = this.consumer == null ? null : this.consumer.apply(ev);
                Profiler.pushEvent(this.id, data);
            }, 0.0f);
        }

        void unregister(EventBus eventBus) {
            eventBus.unregister(this.subscriber);
            this.subscriber = null;
        }

        public EventEvent(int id, Class<T> clazz, Function<T, int[]> consumer) {
            this.id = id;
            this.clazz = clazz;
            this.consumer = consumer;
        }
    }

    private class FailurePanel
    extends JPanel {
        private final JLabel label = new JLabel("Profiler not supported");

        private FailurePanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
        }
    }

    private class StoppedPanel
    extends JPanel {
        private final JButton clear = new JButton("Delete profile");
        private final JButton save = new JButton("Save Profile");
        private final JLabel status = new JLabel("");

        private StoppedPanel() {
            this.clear.addActionListener(ev -> {
                ProfilerPanel.this.data = null;
                ProfilerPanel.this.show(ProfilerPanel.KEY_SETUP);
            });
            this.save.addActionListener(ev -> {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Save profile");
                fc.setSelectedFile(new File(FileSystemView.getFileSystemView().getDefaultDirectory(), "profile.rlp"));
                if (fc.showSaveDialog(this) == 0) {
                    try {
                        Files.write(fc.getSelectedFile().toPath(), ProfilerPanel.this.data, new OpenOption[0]);
                        this.status.setText("Saved");
                    }
                    catch (IOException e) {
                        log.warn("failed to save", (Throwable)e);
                        this.status.setText(e.getMessage());
                        this.status.revalidate();
                    }
                }
            });
            GroupLayout l = new GroupLayout(this);
            this.setLayout(l);
            l.setHorizontalGroup(l.createParallelGroup().addGroup(l.createSequentialGroup().addComponent(this.clear).addComponent(this.save)).addComponent(this.status));
            l.setVerticalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup().addComponent(this.clear).addComponent(this.save)).addComponent(this.status));
        }
    }

    private class RunningPanel
    extends JPanel {
        private final JButton stop = new JButton("Stop profiling");
        private final JProgressBar buffer = new JProgressBar();

        private RunningPanel() {
            this.stop.addActionListener(ev -> ProfilerPanel.this.stopProfiling());
            GroupLayout l = new GroupLayout(this);
            this.setLayout(l);
            l.setHorizontalGroup(l.createParallelGroup().addComponent(this.stop).addComponent(this.buffer));
            l.setVerticalGroup(l.createSequentialGroup().addComponent(this.stop).addComponent(this.buffer));
        }
    }

    private class SetupPanel
    extends JPanel {
        private final JButton start = new JButton("Start profiling");
        private final JSpinner sampleDelay = new JSpinner(new SpinnerNumberModel(1000, 0, 100000, 100));
        private final JSpinner sampleBufferSize = new JSpinner(new SpinnerNumberModel(7168, 1024, 131072, 1));

        private SetupPanel() {
            this.start.addActionListener(ev -> ProfilerPanel.this.startProfiling());
            this.sampleDelay.setToolTipText("How many \u00b5s per sample");
            this.sampleBufferSize.setToolTipText("How many KiB to reserve for storing samples");
            JLabel sampleDelayLabel = new JLabel("\u00b5s per sample");
            JLabel sampleBufferSizeLabel = new JLabel("KiB buffer");
            GroupLayout l = new GroupLayout(this);
            this.setLayout(l);
            l.setHorizontalGroup(l.createParallelGroup().addGroup(l.createSequentialGroup().addComponent(this.sampleDelay).addComponent(sampleDelayLabel)).addGroup(l.createSequentialGroup().addComponent(this.sampleBufferSize).addComponent(sampleBufferSizeLabel)).addComponent(this.start));
            l.setVerticalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleDelay).addComponent(sampleDelayLabel)).addGroup(l.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleBufferSize).addComponent(sampleBufferSizeLabel)).addComponent(this.start));
        }
    }
}

