/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Locale;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profiler {
    private static final Logger log = LoggerFactory.getLogger(Profiler.class);
    private static final long[] heapinfo = new long[4];
    private static final MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
    private static boolean initialized = false;

    public static synchronized void init() {
        if (!initialized) {
            initialized = true;
            String os = OSType.getOSType().name().toLowerCase(Locale.US);
            String name = "invalid";
            String suffix = ".invalid";
            String arch = System.getProperty("os.arch");
            switch (OSType.getOSType()) {
                case Windows: {
                    name = "profiler";
                    suffix = ".dll";
                    break;
                }
                case Linux: {
                    name = "libProfiler";
                    suffix = ".so";
                    break;
                }
                case MacOS: {
                    name = "libProfiler";
                    suffix = ".dylib";
                    arch = "universal";
                }
            }
            String path = "/natives/" + os + "-" + arch + "/" + name + suffix;
            log.info("loading libProfiler from " + path);
            try (InputStream is = Profiler.class.getResourceAsStream(path);){
                if (is == null) {
                    if (Profiler.class.getResource("/natives/cibuilt") == null && System.getenv("RUNELITE_DEBUG_NATIVE_PATH") != null) {
                        Runtime.getRuntime().load(System.getenv("RUNELITE_DEBUG_NATIVE_PATH"));
                        return;
                    }
                    throw new RuntimeException("no natives: " + path);
                }
                File tmp = File.createTempFile("libprofiler", suffix);
                tmp.deleteOnExit();
                try (FileOutputStream fos = new FileOutputStream(tmp);){
                    ByteStreams.copy((InputStream)is, (OutputStream)fos);
                }
                Runtime.getRuntime().load(tmp.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            log.info("libProfiler loaded");
        }
    }

    public static void start(Thread[] threads, int bufferSize, int sampleDelay) {
        Profiler.init();
        int err = Profiler.start0(new Thread("Profiler Agent"), threads, bufferSize, sampleDelay);
        if (err != 0) {
            throw new RuntimeException("Profiler error " + err);
        }
    }

    private static native int start0(Thread var0, Thread[] var1, int var2, int var3);

    public static byte[] stop(byte[] extra) {
        int err = Profiler.stop0(extra);
        if (err != 0) {
            Profiler.free();
            throw new RuntimeException("Profiler error " + err);
        }
        byte[] buf = Profiler.getBuffer();
        Profiler.free();
        return buf;
    }

    private static long[] heapinfo() {
        MemoryUsage heap = memBean.getHeapMemoryUsage();
        Profiler.heapinfo[0] = heap.getUsed();
        Profiler.heapinfo[1] = heap.getCommitted();
        MemoryUsage offheap = memBean.getNonHeapMemoryUsage();
        Profiler.heapinfo[2] = offheap.getUsed();
        Profiler.heapinfo[3] = offheap.getCommitted();
        return heapinfo;
    }

    private static native int pushEvent0(int var0, int[] var1);

    public static void pushEvent(int id, int[] data) {
        int err = Profiler.pushEvent0(id, data);
        if (err != 0) {
            throw new RuntimeException("Profiler error " + err);
        }
    }

    private static native int stop0(byte[] var0);

    private static native int free();

    private static native byte[] getBuffer();

    private static native int status0();

    public static Status status() {
        return Status.values()[Profiler.status0()];
    }

    public static native int bufferOffset();

    public static native int bufferSize();

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_RUNNING = new Status(0);
        public static final /* enum */ Status RUNNING = new Status(1);
        public static final /* enum */ Status FAILED = new Status(2);
        public static final /* enum */ Status STOPPED = new Status(3);
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private Status(int ordinal) {
            assert (this.ordinal() == ordinal);
        }

        static {
            $VALUES = new Status[]{NOT_RUNNING, RUNNING, FAILED, STOPPED};
        }
    }
}

