/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.FeedbackButton;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.awt.LayoutManager;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.inject.Inject;
import javax.management.ObjectName;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.runelite.client.RuneLite;
import net.runelite.client.ui.DynamicGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ManagementPanel.class);

    @Inject
    public ManagementPanel() {
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        this.add(new FeedbackButton.CopyToClipboardButton("Dump threads", () -> ManagementPanel.invokeDiagnosticCommand("threadPrint", new String[0])));
        this.add(new FeedbackButton.CopyToClipboardButton("Dump natives", () -> ManagementPanel.invokeDiagnosticCommand("vmDynlibs", new String[0])));
        this.add(new FeedbackButton.CopyToClipboardButton("OS stats", this::dumpOSStats));
        JCheckBox logGC = new JCheckBox("Log GC details");
        this.add(logGC);
        logGC.addItemListener(ev -> ManagementPanel.setXLog("gc", "gc=" + (logGC.isSelected() ? "debug" : "off")));
    }

    private static String invokeDiagnosticCommand(String action, String ... args) {
        return (String)ManagementFactory.getPlatformMBeanServer().invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), action, new Object[]{args}, new String[]{String[].class.getName()});
    }

    private static void setXLog(String name, String what) {
        File f = new File(RuneLite.LOGS_DIR, name + ".log");
        String out = ManagementPanel.invokeDiagnosticCommand("vmLog", "output=file=" + f.getAbsolutePath(), "what=" + what, "decorators=uptime");
        log.info("xlog: {}", (Object)out);
    }

    private String dumpOSStats() {
        java.lang.management.OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        StringBuilder sb = new StringBuilder();
        Class clazz = java.lang.management.OperatingSystemMXBean.class;
        for (Class clazz2 : new Class[]{UnixOperatingSystemMXBean.class, OperatingSystemMXBean.class}) {
            if (!clazz2.isAssignableFrom(bean.getClass())) continue;
            clazz = clazz2;
            break;
        }
        for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
            Object v;
            if (!((Method)genericDeclaration).getName().startsWith("get") || !Modifier.isPublic(((Method)genericDeclaration).getModifiers()) || Modifier.isStatic(((Method)genericDeclaration).getModifiers()) || ((Method)genericDeclaration).getParameterCount() != 0) continue;
            try {
                v = ((Method)genericDeclaration).invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                v = e;
            }
            sb.append(((Method)genericDeclaration).getName()).append(": ").append(v).append('\n');
        }
        return sb.toString();
    }
}

