/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import java.awt.LayoutManager;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.config.ConfigItemDescriptor;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.ModifierlessKeybind;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;

public class KeybindsPanel
extends JPanel {
    private final ConfigManager configManager;
    private final PluginManager pluginManager;

    @Inject
    public KeybindsPanel(ConfigManager configManager, PluginManager pluginManager) {
        this.configManager = configManager;
        this.pluginManager = pluginManager;
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JButton displayKeybinds = new JButton("Display Keybinds");
        this.add(displayKeybinds);
        displayKeybinds.addActionListener(ev -> this.showKeybindsPanel());
    }

    private void showKeybindsPanel() {
        JTextArea textArea = new JTextArea(this.showKeybinds(), 30, 50);
        textArea.setFont(FontManager.getDefaultFont().deriveFont(12.0f));
        JOptionPane.showMessageDialog(null, new JScrollPane(textArea), "Keybinds", 1);
    }

    private String showKeybinds() {
        Object out = "";
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            ConfigDescriptor cd;
            if (!this.pluginManager.isPluginEnabled(plugin)) continue;
            Config config = this.pluginManager.getPluginConfigProxy(plugin);
            ConfigDescriptor configDescriptor = cd = config == null ? null : this.configManager.getConfigDescriptor(config);
            if (cd == null) continue;
            for (ConfigItemDescriptor cid : cd.getItems()) {
                Keybind keybind;
                if (cid.getType() != Keybind.class && cid.getType() != ModifierlessKeybind.class || Keybind.NOT_SET.equals((Object)(keybind = (Keybind)this.configManager.getConfiguration(cd.getGroup().value(), cid.getItem().keyName(), cid.getType())))) continue;
                out = (String)out + plugin.getName() + " " + cid.name() + ": " + keybind + "\n";
            }
        }
        return out;
    }
}

