/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.DebugPlugin;
import abex.os.debug.HProfStripper;
import abex.os.debug.ZstdOutputStream;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.ObjectName;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import net.runelite.api.Client;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.DynamicGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HeapDumpPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(HeapDumpPanel.class);
    private final Client client;
    private final ConfigManager configManager;
    private final Object[] oomer = new Object[1];
    private final JCheckBox heapDumpOnOOM;
    private final File oomDumpFile = new File(RuneLite.LOGS_DIR, "oom_heap_dump.hprof");
    private File lastDump;

    @Inject
    public HeapDumpPanel(Client client, ConfigManager configManager, @Named(value="developerMode") boolean developerMode) {
        this.client = client;
        this.configManager = configManager;
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JButton heapDump = new JButton("Heap dump");
        this.add(heapDump);
        heapDump.addActionListener(ev -> this.dumpHeap());
        this.heapDumpOnOOM = new JCheckBox("Heap dump on OOM");
        this.heapDumpOnOOM.setSelected(configManager.getConfiguration("debug", "createHeapDump", Boolean.TYPE) == Boolean.TRUE);
        this.heapDumpOnOOM.addChangeListener(_ev -> configManager.setConfiguration("debug", "createHeapDump", (Object)this.heapDumpOnOOM.isSelected()));
        this.add(this.heapDumpOnOOM);
        this.apply();
        if (this.oomDumpFile.exists()) {
            JButton locateDump = new JButton("Open last dump");
            locateDump.addActionListener(_ev -> DebugPlugin.openExplorer(this.oomDumpFile));
            this.add(locateDump);
            this.lastDump = this.oomDumpFile;
        }
        JButton stripDump = new JButton("Strip heap dump");
        stripDump.addActionListener(_ev -> {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Open heap dump");
            fc.setSelectedFile(this.lastDump != null ? this.lastDump : FileSystemView.getFileSystemView().getDefaultDirectory());
            fc.setFileFilter(new FileNameExtensionFilter("Heap dump", "hprof"));
            if (fc.showOpenDialog(this) != 0) {
                return;
            }
            File inFile = fc.getSelectedFile();
            JFrame frame = new JFrame("Stripping heap dump");
            frame.setDefaultCloseOperation(2);
            JLabel l = new JLabel("<html>Stripping heap dump<br>This may take a while...");
            l.setBorder(new EmptyBorder(15, 15, 15, 15));
            frame.add(l);
            frame.setType(Window.Type.POPUP);
            frame.pack();
            frame.setVisible(true);
            frame.toFront();
            new Thread(() -> {
                try {
                    boolean zstd = false;
                    try {
                        ZstdOutputStream.init();
                        zstd = true;
                    }
                    catch (Throwable e) {
                        log.info("unable to init zstd", e);
                    }
                    File outFile = new File(inFile.getParentFile(), inFile.getName().replaceAll("\\.[^.]+$", "") + "_stripped.hprof." + (zstd ? "zstd" : "gz"));
                    new HProfStripper(inFile, outFile, zstd).run();
                    DebugPlugin.openExplorer(outFile);
                }
                catch (IOException e) {
                    log.warn("", (Throwable)e);
                }
                finally {
                    frame.setVisible(false);
                }
            }).start();
        });
        this.add(stripDump);
        if (developerMode) {
            JButton oom = new JButton("oom the client");
            oom.addActionListener(_ev -> {
                Object[] obj = this.oomer;
                while (true) {
                    Object[] waste;
                    obj[0] = waste = new Object[65535];
                    obj = waste;
                }
            });
            this.add(oom);
        }
    }

    public void apply() {
        boolean enabled = this.configManager.getConfiguration("debug", "createHeapDump", Boolean.TYPE) == Boolean.TRUE;
        this.heapDumpOnOOM.setSelected(enabled);
        HotSpotDiagnosticMXBean hsd = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        hsd.setVMOption("HeapDumpOnOutOfMemoryError", "" + enabled);
        if (enabled) {
            hsd.setVMOption("HeapDumpPath", this.oomDumpFile.getAbsolutePath());
        }
    }

    private void dumpHeap() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save heap dump");
        fc.setSelectedFile(new File(FileSystemView.getFileSystemView().getDefaultDirectory(), "dump.hprof"));
        if (fc.showSaveDialog(this) != 0) {
            return;
        }
        File fi = fc.getSelectedFile();
        fi.delete();
        String filename = fi.getAbsoluteFile().getPath();
        this.lastDump = fi;
        this.client.setPassword("");
        JFrame frame = new JFrame("Heap dump");
        frame.setDefaultCloseOperation(2);
        JLabel l = new JLabel("<html>Taking heap dump<br>This may take a while...");
        l.setBorder(new EmptyBorder(15, 15, 15, 15));
        frame.add(l);
        frame.setType(Window.Type.POPUP);
        frame.pack();
        frame.setVisible(true);
        frame.toFront();
        Timer t = new Timer(300, v -> {
            try {
                ManagementFactory.getPlatformMBeanServer().invoke(new ObjectName("com.sun.management:type=HotSpotDiagnostic"), "dumpHeap", new Object[]{filename, true}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
            }
            catch (Exception e) {
                log.warn("unable to capture heap dump", (Throwable)e);
                JOptionPane.showMessageDialog(this, e.toString(), "Heap dump error", 0);
            }
            frame.setVisible(false);
        });
        t.setRepeats(false);
        t.start();
    }
}

