/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.SeekFile;
import abex.os.debug.ZstdOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class HProfStripper {
    private static final int HPROF_UTF8 = 1;
    private static final int HPROF_LOAD_CLASS = 2;
    private static final int HPROF_UNLOAD_CLASS = 3;
    private static final int HPROF_FRAME = 4;
    private static final int HPROF_TRACE = 5;
    private static final int HPROF_ALLOC_SITES = 6;
    private static final int HPROF_HEAP_SUMMARY = 7;
    private static final int HPROF_START_THREAD = 10;
    private static final int HPROF_END_THREAD = 11;
    private static final int HPROF_HEAP_DUMP = 12;
    private static final int HPROF_CPU_SAMPLES = 13;
    private static final int HPROF_CONTROL_SETTINGS = 14;
    private static final int HPROF_HEAP_DUMP_SEGMENT = 28;
    private static final int HPROF_HEAP_DUMP_END = 44;
    private static final int HPROF_ARRAY_OBJECT = 1;
    private static final int HPROF_NORMAL_OBJECT = 2;
    private static final int HPROF_BOOLEAN = 4;
    private static final int HPROF_CHAR = 5;
    private static final int HPROF_FLOAT = 6;
    private static final int HPROF_DOUBLE = 7;
    private static final int HPROF_BYTE = 8;
    private static final int HPROF_SHORT = 9;
    private static final int HPROF_INT = 10;
    private static final int HPROF_LONG = 11;
    private static final int HPROF_GC_ROOT_UNKNOWN = 255;
    private static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    private static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    private static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    private static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    private static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    private static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    private static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    private static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    private static final int HPROF_GC_CLASS_DUMP = 32;
    private static final int HPROF_GC_INSTANCE_DUMP = 33;
    private static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    private static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    private int[] typeSizes;
    private static final byte[] EXPECTED_HEADER = "JAVA PROFILE 1.0.2\u0000".getBytes(StandardCharsets.UTF_8);
    private final SeekFile in;
    private final DataOutputStream out;
    private long start;
    private int identSize;
    private final byte[] zero = new byte[256];

    public HProfStripper(File in, File out, boolean zstd) throws IOException {
        this.in = new SeekFile(in);
        FileOutputStream fos = new FileOutputStream(out);
        OutputStream gzo = zstd ? new ZstdOutputStream(fos, 9) : new GZIPOutputStream(fos){
            {
                this.def.setLevel(3);
            }
        };
        this.out = new DataOutputStream(new BufferedOutputStream(gzo));
    }

    public void run() throws IOException {
        try (SeekFile seekFile = this.in;
             DataOutputStream dataOutputStream = this.out;){
            byte[] header = new byte[EXPECTED_HEADER.length];
            this.in.readFully(header);
            if (!Arrays.equals(header, EXPECTED_HEADER)) {
                throw new IOException("incorrect header " + Arrays.toString(header));
            }
            this.out.write(EXPECTED_HEADER);
            this.identSize = this.in.readInt();
            this.out.writeInt(this.identSize);
            this.typeSizes = new int[]{-1, this.identSize, this.identSize, -1, 1, 2, 4, 8, 1, 2, 4, 8};
            this.out.writeInt(this.in.readInt());
            this.out.writeInt(this.in.readInt());
            this.start = this.in.offset();
            FindKeepers fk = new FindKeepers();
            fk.run();
            Emit emit = new Emit(fk.keepObjects);
            emit.run();
        }
    }

    protected long readId() throws IOException {
        if (this.identSize == 4) {
            return this.in.readU4();
        }
        if (this.identSize == 8) {
            return this.in.readLong();
        }
        throw new UnsupportedOperationException("" + this.identSize);
    }

    protected void writeId(long id) throws IOException {
        if (this.identSize == 4) {
            this.out.writeInt((int)id);
        } else if (this.identSize == 8) {
            this.out.writeLong(id);
        } else {
            throw new UnsupportedOperationException("" + this.identSize);
        }
    }

    private void zero(int bytes) throws IOException {
        this.skip(bytes);
        while (bytes > 0) {
            int chunk = Math.min(this.zero.length, bytes);
            this.out.write(this.zero, 0, chunk);
            bytes -= chunk;
        }
    }

    private void skip(int bytes) throws IOException {
        while (bytes > 0) {
            int read = this.in.skipBytes(bytes);
            if (read < 0) {
                throw new EOFException();
            }
            bytes -= read;
        }
    }

    public static void main(String ... args) throws IOException {
        ZstdOutputStream.init();
        new HProfStripper(new File(args[0]), new File(args[1]), true).run();
    }

    private class Emit
    extends DumpVisitor {
        final Map<Long, ClassMetadata> keepObjects;
        final Map<Integer, Long> sizes;

        @Override
        protected void section(int tag, int ts, int bytes) throws IOException {
            HProfStripper.this.out.writeByte(tag);
            HProfStripper.this.out.writeInt(ts);
            HProfStripper.this.out.writeInt(bytes);
            this.sizes.compute(tag, (_k, v) -> (long)bytes + (v == null ? 0L : v));
            if (tag == 1) {
                long id = HProfStripper.this.readId();
                HProfStripper.this.writeId(id);
                int rem = bytes - HProfStripper.this.identSize;
                if (this.keepObjects.containsKey(id)) {
                    HProfStripper.this.in.copyTo(HProfStripper.this.out, rem);
                } else {
                    HProfStripper.this.zero(rem);
                }
            } else {
                super.section(tag, ts, bytes);
            }
        }

        @Override
        protected void unknownSection(int tag, int ts, int bytes) throws IOException {
            HProfStripper.this.in.copyTo(HProfStripper.this.out, bytes);
        }

        @Override
        protected void readTag(int tag, long obj) throws IOException {
            HProfStripper.this.out.writeByte(tag);
            HProfStripper.this.writeId(obj);
            switch (tag) {
                case 255: {
                    break;
                }
                case 8: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    break;
                }
                case 1: {
                    HProfStripper.this.writeId(HProfStripper.this.readId());
                    break;
                }
                case 2: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    break;
                }
                case 3: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    break;
                }
                case 4: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    break;
                }
                case 7: {
                    break;
                }
                case 32: {
                    HProfStripper.this.in.copyTo(HProfStripper.this.out, 4 + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + 4);
                    int cpsize = HProfStripper.this.in.readUnsignedShort();
                    HProfStripper.this.out.writeShort(cpsize);
                    if (cpsize != 0) {
                        throw new IllegalArgumentException();
                    }
                    int numStatics = HProfStripper.this.in.readUnsignedShort();
                    HProfStripper.this.out.writeShort(numStatics);
                    for (int i = 0; i < numStatics; ++i) {
                        HProfStripper.this.writeId(HProfStripper.this.readId());
                        byte ty = HProfStripper.this.in.readByte();
                        HProfStripper.this.out.writeByte(ty);
                        if (ty == 1 || ty == 2) {
                            HProfStripper.this.writeId(HProfStripper.this.readId());
                            continue;
                        }
                        HProfStripper.this.in.copyTo(HProfStripper.this.out, HProfStripper.this.typeSizes[ty]);
                    }
                    int numInsts = HProfStripper.this.in.readUnsignedShort();
                    HProfStripper.this.out.writeShort(numInsts);
                    HProfStripper.this.in.copyTo(HProfStripper.this.out, (long)numInsts * ((long)HProfStripper.this.identSize + 1L));
                    break;
                }
                case 33: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    long clazz = HProfStripper.this.readId();
                    HProfStripper.this.writeId(clazz);
                    int size = HProfStripper.this.in.readInt();
                    HProfStripper.this.out.writeInt(size);
                    if (this.keepObjects.containsKey(obj)) {
                        HProfStripper.this.in.copyTo(HProfStripper.this.out, size);
                        break;
                    }
                    while (clazz != 0L) {
                        ClassMetadata meta = this.keepObjects.get(clazz);
                        for (byte ty : meta.types) {
                            if (ty == 1 || ty == 2) {
                                HProfStripper.this.writeId(HProfStripper.this.readId());
                                continue;
                            }
                            HProfStripper.this.zero(HProfStripper.this.typeSizes[ty]);
                        }
                        clazz = meta.parent;
                    }
                    break;
                }
                case 34: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    int count = HProfStripper.this.in.readInt();
                    HProfStripper.this.out.writeInt(count);
                    HProfStripper.this.in.copyTo(HProfStripper.this.out, (long)HProfStripper.this.identSize + (long)count * (long)HProfStripper.this.identSize);
                    break;
                }
                case 35: {
                    HProfStripper.this.out.writeInt(HProfStripper.this.in.readInt());
                    int count = HProfStripper.this.in.readInt();
                    HProfStripper.this.out.writeInt(count);
                    byte type = HProfStripper.this.in.readByte();
                    HProfStripper.this.out.writeByte(type);
                    int size = count * HProfStripper.this.typeSizes[type];
                    if (this.keepObjects.containsKey(obj)) {
                        HProfStripper.this.in.copyTo(HProfStripper.this.out, size);
                        break;
                    }
                    HProfStripper.this.zero(size);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("" + tag);
                }
            }
            assert (HProfStripper.this.out.size() == (int)Math.min(Integer.MAX_VALUE, HProfStripper.this.in.offset())) : tag;
        }

        public Emit(Map<Long, ClassMetadata> keepObjects) {
            this.sizes = new HashMap<Integer, Long>();
            this.keepObjects = keepObjects;
        }
    }

    private class FindKeepers
    extends DumpVisitor {
        int pass;
        Map<Long, ClassMetadata> keepObjects;
        Map<Long, Integer> recursiveKeepObjects;
        boolean added;

        private FindKeepers() {
            this.pass = 0;
            this.keepObjects = new HashMap<Long, ClassMetadata>();
            this.recursiveKeepObjects = new HashMap<Long, Integer>();
        }

        @Override
        public void run() throws IOException {
            this.pass = 0;
            while (this.pass == 0 || this.recursiveKeepObjects.size() > 0 && this.added) {
                this.added = false;
                super.run();
                ++this.pass;
            }
        }

        @Override
        protected void section(int tag, int ts, int bytes) throws IOException {
            if (tag == 1) {
                long id = HProfStripper.this.readId();
                this.recursiveKeepObjects.remove(id);
                this.keepObjects.putIfAbsent(id, null);
                HProfStripper.this.skip(bytes - HProfStripper.this.identSize);
                return;
            }
            if (this.pass == 0) {
                if (tag == 2) {
                    HProfStripper.this.skip(4 + HProfStripper.this.identSize + 4);
                    this.keep(HProfStripper.this.readId(), 2);
                    return;
                }
                if (tag == 4) {
                    HProfStripper.this.skip(HProfStripper.this.identSize);
                    this.keep(HProfStripper.this.readId(), 1);
                    this.keep(HProfStripper.this.readId(), 1);
                    this.keep(HProfStripper.this.readId(), 1);
                    HProfStripper.this.skip(8);
                    return;
                }
                if (tag == 10) {
                    HProfStripper.this.skip(4 + HProfStripper.this.identSize + 4);
                    this.keep(HProfStripper.this.readId(), 1);
                    this.keep(HProfStripper.this.readId(), 1);
                    this.keep(HProfStripper.this.readId(), 1);
                    return;
                }
            }
            super.section(tag, ts, bytes);
        }

        @Override
        protected void readTag(int tag, long id) throws IOException {
            Integer keep = this.recursiveKeepObjects.remove(id);
            if (keep != null) {
                this.keepObjects.putIfAbsent(id, null);
            }
            switch (tag) {
                case 33: {
                    int sizeClass;
                    if (keep == null) break;
                    HProfStripper.this.skip(4);
                    long clazz = HProfStripper.this.readId();
                    int size = HProfStripper.this.in.readInt();
                    long end = HProfStripper.this.in.offset() + (long)size;
                    int n = sizeClass = size > 5 + HProfStripper.this.identSize ? 1 : 0;
                    while (clazz != 0L) {
                        ClassMetadata meta = this.keepObjects.get(clazz);
                        if (meta == null) {
                            this.recursiveKeepObjects.put(id, keep);
                            break;
                        }
                        for (byte ty : meta.types) {
                            if (ty == 1 || ty == 2) {
                                this.keep(HProfStripper.this.readId(), keep - sizeClass);
                                continue;
                            }
                            HProfStripper.this.skip(HProfStripper.this.typeSizes[ty]);
                        }
                        clazz = meta.parent;
                    }
                    HProfStripper.this.skip((int)(end - HProfStripper.this.in.offset()));
                    return;
                }
                case 34: {
                    if (keep == null) break;
                    HProfStripper.this.skip(4);
                    int count = HProfStripper.this.in.readInt();
                    HProfStripper.this.skip(HProfStripper.this.identSize);
                    for (int i = 0; i < count; ++i) {
                        this.keep(HProfStripper.this.readId(), keep - 1);
                    }
                    return;
                }
                case 32: {
                    if (this.pass != 0) break;
                    HProfStripper.this.skip(4);
                    long superclass = HProfStripper.this.readId();
                    long cl = HProfStripper.this.readId();
                    this.keep(cl, 3);
                    HProfStripper.this.readId();
                    HProfStripper.this.readId();
                    HProfStripper.this.readId();
                    HProfStripper.this.readId();
                    HProfStripper.this.in.readInt();
                    int cpsize = HProfStripper.this.in.readUnsignedShort();
                    if (cpsize != 0) {
                        throw new IllegalArgumentException();
                    }
                    int numStatics = HProfStripper.this.in.readUnsignedShort();
                    for (int i = 0; i < numStatics; ++i) {
                        long name = HProfStripper.this.readId();
                        this.keep(name, 2);
                        byte ty = HProfStripper.this.in.readByte();
                        HProfStripper.this.skip(HProfStripper.this.typeSizes[ty]);
                    }
                    int numInsts = HProfStripper.this.in.readUnsignedShort();
                    byte[] types = new byte[numInsts];
                    for (int i = 0; i < numInsts; ++i) {
                        long name = HProfStripper.this.readId();
                        byte ty = HProfStripper.this.in.readByte();
                        this.keep(name, 2);
                        types[i] = ty;
                    }
                    this.keepObjects.put(id, new ClassMetadata(superclass, types));
                    return;
                }
            }
            super.readTag(tag, id);
        }

        private void keep(long id, int depth) {
            if (depth <= 0 || id == 0L) {
                return;
            }
            Long id0 = id;
            if (!this.keepObjects.containsKey(id0)) {
                this.added |= this.recursiveKeepObjects.compute(id0, (_k, v) -> Math.max(v == null ? 0 : v, depth)) == depth;
            }
        }
    }

    private static class ClassMetadata {
        final long parent;
        final byte[] types;

        public ClassMetadata(long parent, byte[] types) {
            this.parent = parent;
            this.types = types;
        }
    }

    private class DumpVisitor {
        private DumpVisitor() {
        }

        public void run() throws IOException {
            try {
                HProfStripper.this.in.seek(HProfStripper.this.start);
                while (HProfStripper.this.in.offset() != HProfStripper.this.in.length()) {
                    byte tag = HProfStripper.this.in.readByte();
                    int ts = HProfStripper.this.in.readInt();
                    int bytes = HProfStripper.this.in.readInt();
                    this.section(tag, ts, bytes);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage() + " @ " + HProfStripper.this.in.offset(), e);
            }
        }

        protected void section(int tag, int ts, int bytes) throws IOException {
            if (tag == 12 || tag == 28) {
                long end = HProfStripper.this.in.offset() + (long)bytes;
                while (HProfStripper.this.in.offset() < end) {
                    byte dtag = HProfStripper.this.in.readByte();
                    long id = HProfStripper.this.readId();
                    this.readTag(dtag, id);
                }
                return;
            }
            this.unknownSection(tag, ts, bytes);
        }

        protected void unknownSection(int tag, int ts, int bytes) throws IOException {
            HProfStripper.this.skip(bytes);
        }

        protected void readTag(int tag, long id) throws IOException {
            switch (tag) {
                case 255: {
                    break;
                }
                case 2: 
                case 8: {
                    HProfStripper.this.skip(8);
                    break;
                }
                case 1: {
                    HProfStripper.this.skip(HProfStripper.this.identSize);
                    break;
                }
                case 3: {
                    HProfStripper.this.skip(8);
                    break;
                }
                case 4: {
                    HProfStripper.this.skip(4);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    HProfStripper.this.skip(4);
                    break;
                }
                case 7: {
                    break;
                }
                case 32: {
                    HProfStripper.this.skip(4 + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + HProfStripper.this.identSize + 4);
                    int cpsize = HProfStripper.this.in.readUnsignedShort();
                    if (cpsize != 0) {
                        throw new IllegalArgumentException();
                    }
                    int numStatics = HProfStripper.this.in.readUnsignedShort();
                    for (int i = 0; i < numStatics; ++i) {
                        HProfStripper.this.skip(HProfStripper.this.identSize);
                        byte ty = HProfStripper.this.in.readByte();
                        HProfStripper.this.skip(HProfStripper.this.typeSizes[ty]);
                    }
                    int numInsts = HProfStripper.this.in.readUnsignedShort();
                    HProfStripper.this.skip(numInsts * (HProfStripper.this.identSize + 1));
                    break;
                }
                case 33: {
                    HProfStripper.this.skip(4 + HProfStripper.this.identSize);
                    HProfStripper.this.skip(HProfStripper.this.in.readInt());
                    break;
                }
                case 34: {
                    HProfStripper.this.skip(4);
                    int count = HProfStripper.this.in.readInt();
                    HProfStripper.this.skip(HProfStripper.this.identSize);
                    HProfStripper.this.skip(count * HProfStripper.this.identSize);
                    break;
                }
                case 35: {
                    HProfStripper.this.skip(4);
                    int count = HProfStripper.this.in.readInt();
                    byte type = HProfStripper.this.in.readByte();
                    HProfStripper.this.skip(count * HProfStripper.this.typeSizes[type]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(tag + "@" + HProfStripper.this.in.offset());
                }
            }
        }
    }
}

