/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeedbackButton
extends JButton {
    private static final Logger log = LoggerFactory.getLogger(FeedbackButton.class);
    private String initialText;

    public FeedbackButton(String text) {
        super(text);
        this.initialText = text;
        this.addActionListener(_ev -> this.onClick());
    }

    protected void feedback(String text) {
        this.feedback(text, 5000);
    }

    protected void feedback(String text, int delayMS) {
        this.setText(text);
        Timer t = new Timer(delayMS, ev -> this.setText(this.initialText));
        t.setRepeats(false);
        t.start();
    }

    protected abstract void onClick();

    public static class CopyToClipboardButton
    extends FeedbackButton {
        private final Supplier<String> onClick;

        public CopyToClipboardButton(String text, Supplier<String> onClick) {
            super(text);
            this.onClick = onClick;
        }

        @Override
        protected void onClick() {
            String s;
            try {
                s = this.onClick.get();
            }
            catch (Exception e) {
                log.info("", (Throwable)e);
                s = e.toString();
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
            this.feedback("Copied to clipboard!");
        }
    }
}

