/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.CoreDumpPanel;
import abex.os.debug.DebugConfig;
import abex.os.debug.DebugPanel;
import abex.os.debug.HeapDumpPanel;
import com.google.inject.Provider;
import com.google.inject.Provides;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Debug")
public class DebugPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DebugPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DebugConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Provider<DebugPanel> panelProvider;
    @Inject
    private Provider<CoreDumpPanel> coreDumpPanel;
    @Inject
    private Provider<HeapDumpPanel> heapDumpPanel;
    NavigationButton panelButton;

    protected void startUp() throws Exception {
        this.panelButton = NavigationButton.builder().panel((PluginPanel)this.panelProvider.get()).icon(ImageUtil.loadImageResource(DebugPlugin.class, (String)"panel.png")).tooltip("Debug").priority(9999).build();
        this.clientToolbar.addNavigation(this.panelButton);
        ((CoreDumpPanel)this.coreDumpPanel.get()).patch();
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.panelButton);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged ev) {
        if ("debug".equals(ev.getGroup())) {
            if ("createCoreDump".equals(ev.getKey())) {
                ((CoreDumpPanel)this.coreDumpPanel.get()).patch();
            }
            if ("createHeapDump".equals(ev.getKey())) {
                ((HeapDumpPanel)this.heapDumpPanel.get()).apply();
            }
        }
    }

    @Provides
    DebugConfig provideConfig(ConfigManager configManager) {
        return (DebugConfig)configManager.getConfig(DebugConfig.class);
    }

    public static void openExplorer(File path) {
        if (OSType.getOSType() == OSType.Windows) {
            try {
                new ProcessBuilder("explorer", "/select,\"" + path.getAbsolutePath() + "\"").start();
            }
            catch (IOException e) {
                log.warn("", (Throwable)e);
            }
        } else {
            LinkBrowser.open((String)path.getParentFile().getAbsolutePath());
        }
    }
}

