/*
 * Decompiled with CFR 0.152.
 */
package abex.os.debug;

import abex.os.debug.DebugPlugin;
import abex.os.debug.VMConfigPatch;
import com.google.common.io.PatternFilenameFilter;
import com.google.gson.Gson;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CoreDumpPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(CoreDumpPanel.class);
    private final JLabel statusLabel = new JLabel();
    private final JCheckBox checkBox = new JCheckBox("Core Dumps");
    private final ConfigManager configManager;
    private VMConfigPatch patch;

    @Inject
    public CoreDumpPanel(ConfigManager configManager, Gson gson, @Named(value="developerMode") boolean developerMode) {
        this.configManager = configManager;
        if (developerMode) {
            JButton crash = new JButton("crash the client");
            crash.addActionListener(_ev -> {
                try {
                    Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                    Field f = unsafe.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    Object theUnsafe = f.get(null);
                    unsafe.getMethod("getInt", Long.TYPE).invoke(theUnsafe, 0L);
                }
                catch (ReflectiveOperationException e) {
                    log.warn("", (Throwable)e);
                }
            });
            this.add(crash);
        }
        if (OSType.getOSType() != OSType.Windows) {
            return;
        }
        this.patch = new VMConfigPatch(gson, "Coredumps", "-XX:+CreateCoredumpOnCrash");
        this.statusLabel.setText(this.patch.status());
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        this.add(this.checkBox);
        this.add(this.statusLabel);
        this.checkExistingDumps();
        this.checkBox.setEnabled(VMConfigPatch.isSupported());
        this.checkBox.setSelected(configManager.getConfiguration("debug", "createCoreDump", Boolean.TYPE) == Boolean.TRUE);
        this.checkBox.addChangeListener(e -> configManager.setConfiguration("debug", "createCoreDump", (Object)this.checkBox.isSelected()));
        this.patch();
    }

    private void checkExistingDumps() {
        File[] dumps = new File(".").getAbsoluteFile().listFiles((FilenameFilter)new PatternFilenameFilter("hs_err_pid.*\\.mdmp$"));
        if (dumps == null || dumps.length <= 0) {
            return;
        }
        if (dumps.length > 1) {
            Arrays.sort(dumps, Comparator.comparing(File::lastModified).reversed());
            for (int i = 1; i < dumps.length; ++i) {
                log.info("deleting {}", (Object)dumps[i]);
                dumps[i].delete();
            }
        }
        JButton lastDump = new JButton("Open last coredump");
        lastDump.addActionListener(_ev -> DebugPlugin.openExplorer(dumps[0]));
        this.add(lastDump);
    }

    public void patch() {
        if (OSType.getOSType() != OSType.Windows || !VMConfigPatch.isSupported()) {
            return;
        }
        boolean enabled = this.configManager.getConfiguration("debug", "createCoreDump", Boolean.TYPE) == Boolean.TRUE;
        this.patch.set(enabled);
        SwingUtilities.invokeLater(() -> {
            this.checkBox.setSelected(enabled);
            this.statusLabel.setText(this.patch.status());
        });
    }
}

